/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.ByteQuantity;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.Attribute;
import org.infinispan.server.core.configuration.AuthenticationConfiguration;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;

public abstract class ProtocolServerConfiguration<T extends ProtocolServerConfiguration, A extends AuthenticationConfiguration>
extends ConfigurationElement<T> {
    public static final AttributeDefinition<String> DEFAULT_CACHE_NAME = AttributeDefinition.builder((Enum)Attribute.CACHE, null, String.class).immutable().build();
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"").immutable().build();
    public static final AttributeDefinition<String> HOST = AttributeDefinition.builder((Enum)Attribute.HOST, (Object)"127.0.0.1").immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> PORT = AttributeDefinition.builder((Enum)Attribute.PORT, (Object)-1).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> IDLE_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.IDLE_TIMEOUT, (Object)-1).immutable().build();
    public static final AttributeDefinition<Set<String>> IGNORED_CACHES = AttributeDefinition.builder((Enum)Attribute.IGNORED_CACHES, Collections.emptySet(), Set.class).immutable().build();
    public static final AttributeDefinition<Integer> RECV_BUF_SIZE = AttributeDefinition.builder((Enum)Attribute.RECEIVE_BUFFER_SIZE, (Object)0).immutable().build();
    public static final AttributeDefinition<Integer> SEND_BUF_SIZE = AttributeDefinition.builder((Enum)Attribute.SEND_BUFFER_SIZE, (Object)0).immutable().build();
    public static final AttributeDefinition<Boolean> START_TRANSPORT = AttributeDefinition.builder((Enum)Attribute.START_TRANSPORT, (Object)true).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> TCP_NODELAY = AttributeDefinition.builder((Enum)Attribute.TCP_NODELAY, (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> TCP_KEEPALIVE = AttributeDefinition.builder((Enum)Attribute.TCP_KEEPALIVE, (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> IO_THREADS = AttributeDefinition.builder((Enum)Attribute.IO_THREADS, (Object)(2 * ProcessorInfo.availableProcessors())).immutable().build();
    public static final AttributeDefinition<AdminOperationsHandler> ADMIN_OPERATION_HANDLER = AttributeDefinition.builder((String)"admin-operation-handler", null, AdminOperationsHandler.class).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> ZERO_CAPACITY_NODE = AttributeDefinition.builder((Enum)Attribute.ZERO_CAPACITY_NODE, (Object)false).immutable().build();
    public static final AttributeDefinition<String> SOCKET_BINDING = AttributeDefinition.builder((Enum)Attribute.SOCKET_BINDING, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> IMPLICIT_CONNECTOR = AttributeDefinition.builder((String)"implicit-connector", (Object)false).immutable().autoPersist(false).build();
    public static final AttributeDefinition<String> MAX_CONTENT_LENGTH = AttributeDefinition.builder((String)"max-content-length", (Object)"10MB", String.class).matcher((a1, a2) -> ProtocolServerConfiguration.maxSizeToBytes((String)a1.get()) == ProtocolServerConfiguration.maxSizeToBytes((String)a2.get())).validator(a -> {
        long total = ByteQuantity.parse((String)a);
        if (total > Integer.MAX_VALUE) {
            throw Log.CONFIG.attributeMustBeAnInteger((Number)total, (Enum)Attribute.MAX_CONTENT_LENGTH);
        }
    }).build();
    private volatile boolean enabled = true;
    protected final A authentication;
    protected final SslConfiguration ssl;
    protected final IpFilterConfiguration ipFilter;

    static long maxSizeToBytes(String maxSizeStr) {
        return maxSizeStr != null ? ByteQuantity.parse((String)maxSizeStr) : -1L;
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ProtocolServerConfiguration.class, new AttributeDefinition[]{DEFAULT_CACHE_NAME, NAME, HOST, PORT, IDLE_TIMEOUT, IGNORED_CACHES, RECV_BUF_SIZE, SEND_BUF_SIZE, START_TRANSPORT, TCP_NODELAY, TCP_KEEPALIVE, IO_THREADS, ADMIN_OPERATION_HANDLER, ZERO_CAPACITY_NODE, SOCKET_BINDING, IMPLICIT_CONNECTOR, MAX_CONTENT_LENGTH});
    }

    protected ProtocolServerConfiguration(Enum<?> element, AttributeSet attributes, A authentication, SslConfiguration ssl, IpFilterConfiguration ipFilter) {
        this(element.toString(), attributes, authentication, ssl, ipFilter);
    }

    protected ProtocolServerConfiguration(String element, AttributeSet attributes, A authentication, SslConfiguration ssl, IpFilterConfiguration ipFilter) {
        super(element, attributes, new ConfigurationElement[]{ssl});
        this.authentication = authentication;
        this.ssl = ssl;
        this.ipFilter = ipFilter;
    }

    public String defaultCacheName() {
        return (String)this.attributes.attribute(DEFAULT_CACHE_NAME).get();
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String host() {
        return (String)this.attributes.attribute(HOST).get();
    }

    public int port() {
        return (Integer)this.attributes.attribute(PORT).get();
    }

    public int idleTimeout() {
        return (Integer)this.attributes.attribute(IDLE_TIMEOUT).get();
    }

    public int recvBufSize() {
        return (Integer)this.attributes.attribute(RECV_BUF_SIZE).get();
    }

    public int sendBufSize() {
        return (Integer)this.attributes.attribute(SEND_BUF_SIZE).get();
    }

    public A authentication() {
        return this.authentication;
    }

    public SslConfiguration ssl() {
        return this.ssl;
    }

    public IpFilterConfiguration ipFilter() {
        return this.ipFilter;
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.attributes.attribute(TCP_NODELAY).get();
    }

    public boolean tcpKeepAlive() {
        return (Boolean)this.attributes.attribute(TCP_KEEPALIVE).get();
    }

    public int ioThreads() {
        return (Integer)this.attributes.attribute(IO_THREADS).get();
    }

    public boolean startTransport() {
        return (Boolean)this.attributes.attribute(START_TRANSPORT).get();
    }

    public AdminOperationsHandler adminOperationsHandler() {
        return (AdminOperationsHandler)this.attributes.attribute(ADMIN_OPERATION_HANDLER).get();
    }

    public String socketBinding() {
        return (String)this.attributes.attribute(SOCKET_BINDING).get();
    }

    public boolean zeroCapacityNode() {
        return (Boolean)this.attributes.attribute(ZERO_CAPACITY_NODE).get();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isImplicit() {
        return (Boolean)this.attributes.attribute(IMPLICIT_CONNECTOR).get();
    }

    public String maxContentLength() {
        return (String)this.attributes.attribute(MAX_CONTENT_LENGTH).get();
    }

    public int maxContentLengthBytes() {
        return (int)ByteQuantity.parse((String)((String)this.attributes.attribute(MAX_CONTENT_LENGTH).get()));
    }
}

