/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.logging.Log;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.util.logging.LogFactory;

public abstract class AdminServerTask<T>
implements Task {
    protected static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);

    public final String getName() {
        return "@@" + this.getTaskContextName() + "@" + this.getTaskOperationName();
    }

    public String getType() {
        return AdminServerTask.class.getSimpleName();
    }

    public final T execute(TaskContext taskContext) {
        Map raw = taskContext.getParameters().orElse(Collections.emptyMap());
        Map<String, List<String>> parameters = raw.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof String) {
                return Collections.singletonList((String)value);
            }
            if (value instanceof String[]) {
                return Arrays.asList((String[])value);
            }
            if (value instanceof List) {
                return (List)value;
            }
            if (value instanceof byte[]) {
                return Collections.singletonList(new String((byte[])value, StandardCharsets.UTF_8));
            }
            throw log.illegalParameterType((String)entry.getKey(), value.getClass());
        }));
        List sFlags = parameters.remove("flags");
        return this.execute(taskContext.getCacheManager(), parameters, sFlags != null ? CacheContainerAdmin.AdminFlag.fromString((String)((String)sFlags.get(0))) : EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class));
    }

    protected String requireParameter(Map<String, List<String>> parameters, String parameter) {
        List<String> v = parameters.get(parameter);
        if (v == null) {
            throw log.missingRequiredAdminTaskParameter(this.getName(), parameter);
        }
        return v.get(0);
    }

    protected String getParameter(Map<String, List<String>> parameters, String parameter) {
        List<String> v = parameters.get(parameter);
        return v == null ? null : v.get(0);
    }

    protected abstract T execute(EmbeddedCacheManager var1, Map<String, List<String>> var2, EnumSet<CacheContainerAdmin.AdminFlag> var3);

    public abstract String getTaskContextName();

    public abstract String getTaskOperationName();
}

