/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheException;
import org.infinispan.security.Security;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.manager.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;

public abstract class AdminOperationsHandler
implements TaskEngine {
    final Map<String, AdminServerTask> tasks;

    protected AdminOperationsHandler(AdminServerTask<?> ... tasks) {
        this.tasks = new HashMap<String, AdminServerTask>(tasks.length);
        for (AdminServerTask<?> task : tasks) {
            this.tasks.put(task.getName(), task);
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public List<Task> getTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public <T> CompletionStage<T> runTask(String taskName, TaskContext context, BlockingManager blockingManager) {
        AdminServerTask task = this.tasks.get(taskName);
        Subject subject = context.getSubject().orElse(Security.getSubject());
        return blockingManager.supplyBlocking(() -> {
            try {
                return Security.doAs((Subject)subject, () -> task.execute(context));
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }, (Object)taskName);
    }

    public boolean handles(String taskName) {
        return this.tasks.containsKey(taskName);
    }
}

