/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import java.util.concurrent.ThreadFactory;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.IOURingNativeTransport;

public final class NativeTransport {
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final String USE_IOURING_PROPERTY = "infinispan.server.channel.iouring";
    private static final boolean EPOLL_DISABLED = System.getProperty("infinispan.server.channel.epoll", "true").equalsIgnoreCase("false");
    private static final boolean IOURING_DISABLED = System.getProperty("infinispan.server.channel.iouring", "true").equalsIgnoreCase("false");
    public static final boolean USE_NATIVE_EPOLL = NativeTransport.useNativeEpoll();
    public static final boolean USE_NATIVE_IOURING = NativeTransport.useNativeIOUring();

    private static boolean useNativeEpoll() {
        block4: {
            try {
                Class.forName("io.netty.channel.epoll.Epoll", true, NativeTransport.class.getClassLoader());
                if (Epoll.isAvailable()) {
                    return !EPOLL_DISABLED && IS_LINUX;
                }
                if (IS_LINUX) {
                    Log.SERVER.epollNotAvailable(Epoll.unavailabilityCause().toString());
                }
            }
            catch (ClassNotFoundException e) {
                if (!IS_LINUX) break block4;
                Log.SERVER.epollNotAvailable(e.getMessage());
            }
        }
        return false;
    }

    private static boolean useNativeIOUring() {
        block4: {
            try {
                Class.forName("io.netty.incubator.channel.uring.IOUring", true, NativeTransport.class.getClassLoader());
                if (IOUring.isAvailable()) {
                    return !IOURING_DISABLED && IS_LINUX;
                }
                if (IS_LINUX) {
                    Log.SERVER.ioUringNotAvailable(IOUring.unavailabilityCause().toString());
                }
            }
            catch (ClassNotFoundException e) {
                if (!IS_LINUX) break block4;
                Log.SERVER.ioUringNotAvailable(e.getMessage());
            }
        }
        return false;
    }

    public static Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        if (USE_NATIVE_EPOLL) {
            Log.SERVER.usingTransport("Epoll");
            return EpollServerSocketChannel.class;
        }
        if (USE_NATIVE_IOURING) {
            Log.SERVER.usingTransport("IOUring");
            return IOURingNativeTransport.serverSocketChannelClass();
        }
        Log.SERVER.usingTransport("NIO");
        return NioServerSocketChannel.class;
    }

    public static MultithreadEventLoopGroup createEventLoopGroup(int maxExecutors, ThreadFactory threadFactory) {
        if (USE_NATIVE_EPOLL) {
            return new EpollEventLoopGroup(maxExecutors, threadFactory);
        }
        if (USE_NATIVE_IOURING) {
            return IOURingNativeTransport.createEventLoopGroup(maxExecutors, threadFactory);
        }
        return new NioEventLoopGroup(maxExecutors, threadFactory);
    }
}

