/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.nio.file.Path;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.sql.DataSource;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.tasks.TaskManager;

public interface ServerManagement {
    public static final String MODE = "mode";
    public static final String URL = "url";
    public static final String REALM = "realm";
    public static final String CLIENT_ID = "clientId";

    public ComponentStatus getStatus();

    public void serializeConfiguration(ConfigurationWriter var1);

    public void serverStop(List<String> var1);

    public void clusterStop();

    public void containerStop();

    @Deprecated(forRemoval=true, since="13.0")
    default public DefaultCacheManager getCacheManager(String name) {
        DefaultCacheManager cm = this.getCacheManager();
        return cm.getName().equals(name) ? cm : null;
    }

    public DefaultCacheManager getCacheManager();

    public ServerStateManager getServerStateManager();

    public Map<String, String> getLoginConfiguration(ProtocolServer var1);

    public Map<String, ProtocolServer> getProtocolServers();

    public TaskManager getTaskManager();

    public CompletionStage<Path> getServerReport();

    public BackupManager getBackupManager();

    public Map<String, DataSource> getDataSources();

    public Path getServerDataPath();

    public Map<String, List<Principal>> getUsers();

    public CompletionStage<Void> flushSecurityCaches();

    public Json overviewReport();

    public Json securityOverviewReport();
}

