/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.telemetry.inmemory;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import org.infinispan.server.core.telemetry.inmemory.InMemorySpanExporter;

public class InMemoryTelemetryService {
    private static InMemoryTelemetryService singleton;
    private final InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
    private final SdkTracerProvider tracerProvider;
    private final OpenTelemetry openTelemetry;

    private InMemoryTelemetryService() {
        GlobalOpenTelemetry.resetForTest();
        SpanProcessor spanProcessor = SimpleSpanProcessor.create((SpanExporter)this.spanExporter);
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setSampler(Sampler.alwaysOn()).addSpanProcessor(spanProcessor);
        this.tracerProvider = builder.build();
        this.openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(this.tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
    }

    public static synchronized InMemoryTelemetryService instance() {
        if (singleton == null) {
            singleton = new InMemoryTelemetryService();
        }
        return singleton;
    }

    public void reset() {
        this.tracerProvider.forceFlush();
        this.spanExporter.reset();
    }

    public OpenTelemetry openTelemetry() {
        return this.openTelemetry;
    }

    public InMemorySpanExporter spanExporter() {
        return this.spanExporter;
    }
}

