/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.iteration;

import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6500)
@Scope(value=Scopes.NONE)
public class IterationFilter<K, V, C>
extends AbstractKeyValueFilterConverter<K, V, C> {
    @ProtoField(value=1)
    final MediaType requestType;
    @ProtoField(value=2)
    final MediaType storageMediaType;
    final KeyValueFilterConverter<K, V, C> providedFilter;
    private transient Transcoder applyBefore;
    private transient Transcoder applyAfter;

    public IterationFilter(MediaType storageMediaType, MediaType requestType, KeyValueFilterConverter<K, V, C> providedFilter) {
        this.storageMediaType = storageMediaType;
        this.requestType = requestType;
        this.providedFilter = providedFilter;
    }

    @ProtoFactory
    IterationFilter(MediaType storageMediaType, MediaType requestType, WrappedMessage wrappedProvidedFilter) {
        this(storageMediaType, requestType, (KeyValueFilterConverter)WrappedMessages.unwrap((WrappedMessage)wrappedProvidedFilter));
    }

    @ProtoField(number=3, name="providedFilter")
    WrappedMessage getWrappedProvidedFilter() {
        return WrappedMessages.orElseNull(this.providedFilter);
    }

    public C filterAndConvert(K key, V value, Metadata metadata) {
        if (this.providedFilter != null) {
            Object result;
            Object keyTranscoded = key;
            Object valueTranscoded = value;
            if (this.applyBefore != null) {
                keyTranscoded = this.applyBefore.transcode(key, this.storageMediaType, this.providedFilter.format());
                valueTranscoded = this.applyBefore.transcode(value, this.storageMediaType, this.providedFilter.format());
            }
            if ((result = this.providedFilter.filterAndConvert(keyTranscoded, valueTranscoded, metadata)) == null) {
                return null;
            }
            if (this.applyAfter == null) {
                return (C)result;
            }
            return (C)this.applyAfter.transcode(result, this.providedFilter.format(), this.requestType);
        }
        return (C)value;
    }

    @Inject
    public void injectDependencies(Cache cache, EncoderRegistry encoderRegistry) {
        if (this.providedFilter != null) {
            ComponentRegistry.of((Cache)cache).wireDependencies(this.providedFilter);
            MediaType filterFormat = this.providedFilter.format();
            if (filterFormat != null && !filterFormat.equals((Object)this.storageMediaType)) {
                this.applyBefore = encoderRegistry.getTranscoder(filterFormat, this.storageMediaType);
            }
            if (filterFormat != null && !filterFormat.equals((Object)this.requestType)) {
                this.applyAfter = encoderRegistry.getTranscoder(filterFormat, this.requestType);
            }
        }
    }
}

