/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.ipfilter.IpFilterRule;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.server.core.dataconversion.TranscodingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=5001, max=6000)
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");
    public static final Log SECURITY = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.SECURITY");
    public static final Log SERVER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.SERVER");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported", id=5003)
    public void exceptionReported(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still bound to %s", id=5005)
    public void channelStillBound(Channel var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s is still connected to %s", id=5007)
    public void channelStillConnected(Channel var1, SocketAddress var2);

    @Message(value="Illegal number of workerThreads: %d", id=5010)
    public IllegalArgumentException illegalWorkerThreads(int var1);

    @Message(value="Idle timeout can't be lower than -1: %d", id=5011)
    public IllegalArgumentException illegalIdleTimeout(int var1);

    @Message(value="Receive Buffer Size can't be lower than 0: %d", id=5012)
    public IllegalArgumentException illegalReceiveBufferSize(int var1);

    @Message(value="Send Buffer Size can't be lower than 0: %d", id=5013)
    public IllegalArgumentException illegalSendBufferSize(int var1);

    @Message(value="SSL Enabled but no KeyStore specified", id=5014)
    public CacheConfigurationException noSSLKeyManagerConfiguration();

    @Message(value="A password is required to open the KeyStore '%s'", id=5016)
    public CacheConfigurationException missingKeyStorePassword(String var1);

    @Message(value="A password is required to open the TrustStore '%s'", id=5017)
    public CacheConfigurationException missingTrustStorePassword(String var1);

    @Message(value="Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext", id=5018)
    public CacheConfigurationException xorSSLContext();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No members for new topology after applying consistent hash %s filtering into base topology %s", id=5019)
    public void noMembersInHashTopology(ConsistentHash var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No members in new topology", id=5020)
    public void noMembersInTopology();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using Netty SocketChannel %s for %s", id=5025)
    public void createdSocketChannel(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using Netty EventLoop %s for %s", id=5026)
    public void createdNettyEventLoop(String var1, String var2);

    @Message(value="SSL Enabled but no SNI domain configured", id=5027)
    public CacheConfigurationException noSniDomainConfigured();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Native Epoll transport not available, using NIO instead: %s", id=5028)
    public void epollNotAvailable(String var1);

    @Message(value="No task manager available to register the admin operations handler", id=5029)
    public CacheConfigurationException cannotRegisterAdminOperationsHandler();

    @Message(value="Administration task '%s' invoked without required parameter '%s'", id=5030)
    public NullPointerException missingRequiredAdminTaskParameter(String var1, String var2);

    @Message(value="The supplied configuration for cache '%s' is missing a named configuration for it: %s", id=5031)
    public CacheConfigurationException missingCacheConfiguration(String var1, String var2);

    @Message(value="Data format '%s' not supported", id=5033)
    public TranscodingException unsupportedDataFormat(MediaType var1);

    @Message(value="Cannot create clustered caches in non-clustered servers", id=5034)
    public UnsupportedOperationException cannotCreateClusteredCache();

    @Message(value="Class '%s' blocked by deserialization allow list. Include the class name in the server cache manager allow list to authorize.", id=5035)
    public CacheException errorDeserializing(String var1);

    @Message(value="Illegal number of ioThreads: %d", id=5036)
    public IllegalArgumentException illegalIOThreads(int var1);

    @Message(value="Illegal type for parameter '%s': %s", id=5038)
    public IllegalArgumentException illegalParameterType(String var1, Class<?> var2);

    @Message(value="Cannot create cluster backup", id=5039)
    public CacheException errorCreatingBackup(@Cause Throwable var1);

    @Message(value="Cannot restore cluster backup '%s'", id=5040)
    public CacheException errorRestoringBackup(Path var1, @Cause Throwable var2);

    @Message(value="Cannot perform backup, backup currently in progress", id=5041)
    public CacheException backupInProgress();

    @Message(value="Cannot restore content, restore currently in progress", id=5042)
    public CacheException restoreInProgress();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting backup '%s'", id=5043)
    public void initiatingBackup(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Backup file created '%s'", id=5044)
    public void backupComplete(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting restore '%s' of '%s'", id=5045)
    public void initiatingRestore(String var1, Path var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Restore '%s' complete", id=5046)
    public void restoreComplete(String var1);

    @Message(value="%s '%s' not found in the backup archive", id=5047)
    public CacheException unableToFindBackupResource(String var1, Set<String> var2);

    @Message(value="%s '%s' does not exist", id=5048)
    public CacheException unableToFindResource(String var1, String var2);

    @Message(value="Cannot perform backup, backup already exists with name '%s'", id=5049)
    public CacheException backupAlreadyExists(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Deleted backup '%s'", id=5050)
    public void backupDeleted(String var1);

    @Message(value="Cannot perform restore, restore already exists with name '%s'", id=5051)
    public CacheException restoreAlreadyExists(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rejected connection from '%s' using rule '%s'", id=5052)
    public void ipFilterConnectionRejection(InetSocketAddress var1, IpFilterRule var2);

    @Message(value="The supplied configuration for cache '%s' must contain a single cache configuration for it: %s", id=5053)
    public CacheConfigurationException configurationMustContainSingleCache(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Native IOUring transport not available, using NIO instead: %s", id=5054)
    public void ioUringNotAvailable(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using transport: %s", id=5055)
    public void usingTransport(String var1);

    @Message(value="Cannot enable authentication without specifying a SaslAuthenticationProvider", id=5056)
    public CacheConfigurationException saslAuthenticationProvider();

    @Message(value="The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]", id=5057)
    public CacheConfigurationException invalidAllowedMechs(Set<String> var1, Set<String> var2);

    @Message(value="A serverName must be specified when enabling authentication", id=5058)
    public CacheConfigurationException missingServerName();

    @Message(value="EXTERNAL SASL mechanism not allowed without SSL client certificate", id=5059)
    public SecurityException externalMechNotAllowedWithoutSSLClientCert();

    @Message(value="Factory '%s' not found in server", id=5060)
    public IllegalStateException missingKeyValueFilterConverterFactory(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Removed unclosed iterator '%s'", id=5061)
    public void removedUnclosedIterator(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushed cache for security realm '%s'", id=5062)
    public void flushRealmCache(String var1);

    @Message(value="Unable to read backup '%s'", id=5063)
    public CacheException unableToReadBackup(Path var1, @Cause IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Request was too long, closing socket to '%s'", id=5064)
    public void requestTooLarge(Channel var1, @Cause TooLongFrameException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="For better performance, it is recommended to use Netty's default thread factory. Current: %s", id=5065)
    public void useNettyThreadFactory(Class<?> var1);
}

