/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.iteration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.Metadata;

@Scope(value=Scopes.NONE)
public class IterationFilter<K, V, C>
extends AbstractKeyValueFilterConverter<K, V, C> {
    final Optional<KeyValueFilterConverter<K, V, C>> providedFilter;
    private final MediaType requestType;
    private final MediaType storageMediaType;
    private transient Transcoder applyBefore;
    private transient Transcoder applyAfter;

    public IterationFilter(MediaType storageMediaType, MediaType requestType, Optional<KeyValueFilterConverter<K, V, C>> providedFilter) {
        this.storageMediaType = storageMediaType;
        this.requestType = requestType;
        this.providedFilter = providedFilter;
    }

    public C filterAndConvert(K key, V value, Metadata metadata) {
        if (this.providedFilter.isPresent()) {
            Object result;
            KeyValueFilterConverter<K, V, C> f = this.providedFilter.get();
            Object keyTranscoded = key;
            Object valueTranscoded = value;
            if (this.applyBefore != null) {
                keyTranscoded = this.applyBefore.transcode(key, this.storageMediaType, f.format());
                valueTranscoded = this.applyBefore.transcode(value, this.storageMediaType, f.format());
            }
            if ((result = f.filterAndConvert(keyTranscoded, valueTranscoded, metadata)) == null) {
                return null;
            }
            if (this.applyAfter == null) {
                return (C)result;
            }
            return (C)this.applyAfter.transcode(result, f.format(), this.requestType);
        }
        return (C)value;
    }

    @Inject
    public void injectDependencies(Cache cache, EncoderRegistry encoderRegistry) {
        this.providedFilter.ifPresent(kvfc -> {
            ComponentRegistry.of((Cache)cache).wireDependencies(kvfc);
            MediaType filterFormat = kvfc.format();
            if (filterFormat != null && !filterFormat.equals((Object)this.storageMediaType)) {
                this.applyBefore = encoderRegistry.getTranscoder(filterFormat, this.storageMediaType);
            }
            if (filterFormat != null && !filterFormat.equals((Object)this.requestType)) {
                this.applyAfter = encoderRegistry.getTranscoder(filterFormat, this.requestType);
            }
        });
    }

    public static class IterationFilterExternalizer
    extends AbstractExternalizer<IterationFilter> {
        public Set<Class<? extends IterationFilter>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{IterationFilter.class});
        }

        public void writeObject(ObjectOutput output, IterationFilter object) throws IOException {
            if (object.providedFilter.isPresent()) {
                output.writeBoolean(true);
                output.writeObject(object.providedFilter.get());
            } else {
                output.writeBoolean(false);
            }
            output.writeObject(object.storageMediaType);
            output.writeObject(object.requestType);
        }

        public IterationFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Optional<Object> filter = input.readBoolean() ? Optional.of((KeyValueFilterConverter)input.readObject()) : Optional.empty();
            MediaType storeType = (MediaType)input.readObject();
            MediaType requestType = (MediaType)input.readObject();
            return new IterationFilter(storeType, requestType, filter);
        }
    }
}

