/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.iteration;

import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.container.entries.CacheEntry;

public class IterableIterationResult {
    private final Set<Integer> finishedSegments;
    private final Status statusCode;
    private final List<CacheEntry> entries;
    private final boolean metadata;
    private final Function<Object, Object> resultFunction;

    IterableIterationResult(Set<Integer> finishedSegments, Status statusCode, List<CacheEntry> entries, boolean metadata, Function<Object, Object> resultFunction) {
        this.finishedSegments = finishedSegments;
        this.statusCode = statusCode;
        this.entries = entries;
        this.metadata = metadata;
        this.resultFunction = resultFunction;
    }

    public Status getStatusCode() {
        return this.statusCode;
    }

    public List<CacheEntry> getEntries() {
        return this.entries;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public byte[] segmentsToBytes() {
        BitSet bs = new BitSet();
        this.finishedSegments.stream().forEach(bs::set);
        return bs.toByteArray();
    }

    public String toString() {
        return "IterableIterationResult{finishedSegments=" + String.valueOf(this.finishedSegments) + ", statusCode=" + String.valueOf((Object)this.statusCode) + ", entries=" + String.valueOf(this.entries) + ", metadata=" + this.metadata + "}";
    }

    public Function<Object, Object> getResultFunction() {
        return this.resultFunction;
    }

    public static enum Status {
        Success,
        Finished,
        InvalidIteration;

    }
}

