/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.logging;

import io.netty.channel.Channel;
import io.netty.handler.ipfilter.IpFilterRule;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.dataconversion.TranscodingException;
import org.infinispan.server.core.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void channelStillBound(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillBound$str(), (Object)ch, (Object)address);
    }

    protected String channelStillBound$str() {
        return "ISPN005005: %s is still bound to %s";
    }

    @Override
    public final void channelStillConnected(Channel ch, SocketAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.channelStillConnected$str(), (Object)ch, (Object)address);
    }

    protected String channelStillConnected$str() {
        return "ISPN005007: %s is still connected to %s";
    }

    protected String illegalWorkerThreads$str() {
        return "ISPN005010: Illegal number of workerThreads: %d";
    }

    @Override
    public final IllegalArgumentException illegalWorkerThreads(int workerThreads) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalWorkerThreads$str(), workerThreads));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String illegalIdleTimeout$str() {
        return "ISPN005011: Idle timeout can't be lower than -1: %d";
    }

    @Override
    public final IllegalArgumentException illegalIdleTimeout(int idleTimeout) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalIdleTimeout$str(), idleTimeout));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalReceiveBufferSize$str() {
        return "ISPN005012: Receive Buffer Size can't be lower than 0: %d";
    }

    @Override
    public final IllegalArgumentException illegalReceiveBufferSize(int recvBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalReceiveBufferSize$str(), recvBufSize));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalSendBufferSize$str() {
        return "ISPN005013: Send Buffer Size can't be lower than 0: %d";
    }

    @Override
    public final IllegalArgumentException illegalSendBufferSize(int sendBufSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalSendBufferSize$str(), sendBufSize));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSSLKeyManagerConfiguration$str() {
        return "ISPN005014: SSL Enabled but no KeyStore specified";
    }

    @Override
    public final CacheConfigurationException noSSLKeyManagerConfiguration() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSSLKeyManagerConfiguration$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingKeyStorePassword$str() {
        return "ISPN005016: A password is required to open the KeyStore '%s'";
    }

    @Override
    public final CacheConfigurationException missingKeyStorePassword(String keyStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingKeyStorePassword$str(), keyStore));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingTrustStorePassword$str() {
        return "ISPN005017: A password is required to open the TrustStore '%s'";
    }

    @Override
    public final CacheConfigurationException missingTrustStorePassword(String trustStore) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingTrustStorePassword$str(), trustStore));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String xorSSLContext$str() {
        return "ISPN005018: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    }

    @Override
    public final CacheConfigurationException xorSSLContext() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.xorSSLContext$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void createdSocketChannel(String channelClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdSocketChannel$str(), (Object)channelClassName, (Object)configuration);
    }

    protected String createdSocketChannel$str() {
        return "ISPN005025: Using Netty SocketChannel %s for %s";
    }

    @Override
    public final void createdNettyEventLoop(String eventLoopClassName, String configuration) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdNettyEventLoop$str(), (Object)eventLoopClassName, (Object)configuration);
    }

    protected String createdNettyEventLoop$str() {
        return "ISPN005026: Using Netty EventLoop %s for %s";
    }

    protected String noSniDomainConfigured$str() {
        return "ISPN005027: SSL Enabled but no SNI domain configured";
    }

    @Override
    public final CacheConfigurationException noSniDomainConfigured() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.noSniDomainConfigured$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void epollNotAvailable(String message) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.epollNotAvailable$str(), (Object)message);
    }

    protected String epollNotAvailable$str() {
        return "ISPN005028: Native Epoll transport not available, using NIO instead: %s";
    }

    protected String cannotRegisterAdminOperationsHandler$str() {
        return "ISPN005029: No task manager available to register the admin operations handler";
    }

    @Override
    public final CacheConfigurationException cannotRegisterAdminOperationsHandler() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotRegisterAdminOperationsHandler$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingRequiredAdminTaskParameter$str() {
        return "ISPN005030: Administration task '%s' invoked without required parameter '%s'";
    }

    @Override
    public final NullPointerException missingRequiredAdminTaskParameter(String name, String parameter) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.missingRequiredAdminTaskParameter$str(), name, parameter));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCacheConfiguration$str() {
        return "ISPN005031: The supplied configuration for cache '%s' is missing a named configuration for it: %s";
    }

    @Override
    public final CacheConfigurationException missingCacheConfiguration(String name, String configuration) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingCacheConfiguration$str(), name, configuration));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedDataFormat$str() {
        return "ISPN005033: Data format '%s' not supported";
    }

    @Override
    public final TranscodingException unsupportedDataFormat(MediaType contentFormat) {
        TranscodingException result = new TranscodingException(String.format(this.getLoggingLocale(), this.unsupportedDataFormat$str(), contentFormat));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateClusteredCache$str() {
        return "ISPN005034: Cannot create clustered caches in non-clustered servers";
    }

    @Override
    public final UnsupportedOperationException cannotCreateClusteredCache() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotCreateClusteredCache$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorDeserializing$str() {
        return "ISPN005035: Class '%s' blocked by deserialization allow list. Include the class name in the server cache manager allow list to authorize.";
    }

    @Override
    public final CacheException errorDeserializing(String className) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorDeserializing$str(), className));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalIOThreads$str() {
        return "ISPN005036: Illegal number of ioThreads: %d";
    }

    @Override
    public final IllegalArgumentException illegalIOThreads(int ioThreads) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalIOThreads$str(), ioThreads));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalParameterType$str() {
        return "ISPN005038: Illegal type for parameter '%s': %s";
    }

    @Override
    public final IllegalArgumentException illegalParameterType(String parameter, Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalParameterType$str(), parameter, type));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingBackup$str() {
        return "ISPN005039: Cannot create cluster backup";
    }

    @Override
    public final CacheException errorCreatingBackup(Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorCreatingBackup$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRestoringBackup$str() {
        return "ISPN005040: Cannot restore cluster backup '%s'";
    }

    @Override
    public final CacheException errorRestoringBackup(Path path, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.errorRestoringBackup$str(), path), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backupInProgress$str() {
        return "ISPN005041: Cannot perform backup, backup currently in progress";
    }

    @Override
    public final CacheException backupInProgress() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.backupInProgress$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String restoreInProgress$str() {
        return "ISPN005042: Cannot restore content, restore currently in progress";
    }

    @Override
    public final CacheException restoreInProgress() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.restoreInProgress$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void initiatingBackup(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initiatingBackup$str(), (Object)name);
    }

    protected String initiatingBackup$str() {
        return "ISPN005043: Starting backup '%s'";
    }

    @Override
    public final void backupComplete(String backupName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.backupComplete$str(), (Object)backupName);
    }

    protected String backupComplete$str() {
        return "ISPN005044: Backup file created '%s'";
    }

    @Override
    public final void initiatingRestore(String name, Path backup) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initiatingRestore$str(), (Object)name, (Object)backup);
    }

    protected String initiatingRestore$str() {
        return "ISPN005045: Starting restore '%s' of '%s'";
    }

    @Override
    public final void restoreComplete(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.restoreComplete$str(), (Object)name);
    }

    protected String restoreComplete$str() {
        return "ISPN005046: Restore '%s' complete";
    }

    protected String unableToFindBackupResource$str() {
        return "ISPN005047: %s '%s' not found in the backup archive";
    }

    @Override
    public final CacheException unableToFindBackupResource(String resource, Set<String> resourceNames) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToFindBackupResource$str(), resource, resourceNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToFindResource$str() {
        return "ISPN005048: %s '%s' does not exist";
    }

    @Override
    public final CacheException unableToFindResource(String resource, String resourceName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToFindResource$str(), resource, resourceName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backupAlreadyExists$str() {
        return "ISPN005049: Cannot perform backup, backup already exists with name '%s'";
    }

    @Override
    public final CacheException backupAlreadyExists(String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.backupAlreadyExists$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void backupDeleted(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.backupDeleted$str(), (Object)name);
    }

    protected String backupDeleted$str() {
        return "ISPN005050: Deleted backup '%s'";
    }

    protected String restoreAlreadyExists$str() {
        return "ISPN005051: Cannot perform restore, restore already exists with name '%s'";
    }

    @Override
    public final CacheException restoreAlreadyExists(String name) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.restoreAlreadyExists$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void ipFilterConnectionRejection(InetSocketAddress remoteAddress, IpFilterRule rule) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ipFilterConnectionRejection$str(), (Object)remoteAddress, (Object)rule);
    }

    protected String ipFilterConnectionRejection$str() {
        return "ISPN005052: Rejected connection from '%s' using rule '%s'";
    }

    protected String configurationMustContainSingleCache$str() {
        return "ISPN005053: The supplied configuration for cache '%s' must contain a single cache configuration for it: %s";
    }

    @Override
    public final CacheConfigurationException configurationMustContainSingleCache(String name, String configuration) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.configurationMustContainSingleCache$str(), name, configuration));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void ioUringNotAvailable(String message) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ioUringNotAvailable$str(), (Object)message);
    }

    protected String ioUringNotAvailable$str() {
        return "ISPN005054: Native IOUring transport not available, using NIO instead: %s";
    }

    @Override
    public final void usingTransport(String transportName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingTransport$str(), (Object)transportName);
    }

    protected String usingTransport$str() {
        return "ISPN005055: Using transport: %s";
    }

    protected String saslAuthenticationProvider$str() {
        return "ISPN005056: Cannot enable authentication without specifying a SaslAuthenticationProvider";
    }

    @Override
    public final CacheConfigurationException saslAuthenticationProvider() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.saslAuthenticationProvider$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidAllowedMechs$str() {
        return "ISPN005057: The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]";
    }

    @Override
    public final CacheConfigurationException invalidAllowedMechs(Set<String> allowedMechs, Set<String> allMechs) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidAllowedMechs$str(), allowedMechs, allMechs));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingServerName$str() {
        return "ISPN005058: A serverName must be specified when enabling authentication";
    }

    @Override
    public final CacheConfigurationException missingServerName() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.missingServerName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String externalMechNotAllowedWithoutSSLClientCert$str() {
        return "ISPN005059: EXTERNAL SASL mechanism not allowed without SSL client certificate";
    }

    @Override
    public final SecurityException externalMechNotAllowedWithoutSSLClientCert() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.externalMechNotAllowedWithoutSSLClientCert$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingKeyValueFilterConverterFactory$str() {
        return "ISPN006016: Factory '%s' not found in server";
    }

    @Override
    public final IllegalStateException missingKeyValueFilterConverterFactory(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingKeyValueFilterConverterFactory$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void removedUnclosedIterator(String iteratorId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.removedUnclosedIterator$str(), (Object)iteratorId);
    }

    protected String removedUnclosedIterator$str() {
        return "ISPN028026: Removed unclosed iterator '%s'";
    }

    @Override
    public final void flushRealmCache(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.flushRealmCache$str(), (Object)name);
    }

    protected String flushRealmCache$str() {
        return "ISPN028027: Flushed cache for security realm '%s'";
    }

    protected String unableToReadBackup$str() {
        return "ISPN028028: Unable to read backup '%s'";
    }

    @Override
    public final CacheException unableToReadBackup(Path backup, IOException e) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToReadBackup$str(), backup), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

