/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipFile;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.ContainerResource;
import org.infinispan.server.core.backup.resources.ContainerResourceFactory;
import org.infinispan.server.core.logging.Log;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;

class BackupReader {
    private static final Log log = (Log)LogFactory.getLog(BackupReader.class, Log.class);
    private final BlockingManager blockingManager;
    private final Map<String, DefaultCacheManager> cacheManagers;
    private final ParserRegistry parserRegistry;

    public BackupReader(BlockingManager blockingManager, Map<String, DefaultCacheManager> cacheManagers, ParserRegistry parserRegistry) {
        this.blockingManager = blockingManager;
        this.cacheManagers = cacheManagers;
        this.parserRegistry = parserRegistry;
    }

    CompletionStage<Void> restore(Path backup, Map<String, BackupManager.Resources> params) {
        return this.blockingManager.runBlocking(() -> {
            try (ZipFile zip = new ZipFile(backup.toFile());){
                Properties manifest = this.readManifestAndValidate(zip);
                List<String> backupContainers = Arrays.asList(manifest.getProperty("containers").split(","));
                HashSet<String> requestedContainers = new HashSet<String>(params.keySet());
                requestedContainers.removeAll(backupContainers);
                if (!requestedContainers.isEmpty()) {
                    throw log.unableToFindBackupResource("Containers", requestedContainers);
                }
                AggregateCompletionStage stages = CompletionStages.aggregateCompletionStage();
                for (Map.Entry e : params.entrySet()) {
                    stages.dependsOn(this.restoreContainer((String)e.getKey(), (BackupManager.Resources)e.getValue(), zip));
                }
                CompletionStages.join((CompletionStage)stages.freeze());
            }
            catch (IOException e) {
                throw new CacheException(String.format("Unable to read zip file '%s'", backup));
            }
        }, (Object)"process-containers");
    }

    private CompletionStage<Void> restoreContainer(String containerName, BackupManager.Resources params, ZipFile zip) {
        EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(containerName);
        Path containerRoot = Paths.get("containers", containerName);
        Properties properties = this.readProperties(containerRoot.resolve("container.properties"), zip);
        Collection<ContainerResource> resources = ContainerResourceFactory.getResources(params, this.blockingManager, cm, this.parserRegistry, containerRoot);
        resources.forEach(r -> r.prepareAndValidateRestore(properties));
        AggregateCompletionStage stages = CompletionStages.aggregateCompletionStage();
        for (ContainerResource cr : resources) {
            stages.dependsOn(cr.restore(zip));
        }
        return stages.freeze();
    }

    private Properties readManifestAndValidate(ZipFile zip) {
        Path manifestPath = Paths.get("manifest.properties", new String[0]);
        Properties properties = this.readProperties(manifestPath, zip);
        String version = properties.getProperty("version");
        if (version == null) {
            throw new IllegalStateException("Missing manifest version");
        }
        int majorVersion = Integer.parseInt(version.split("[\\.\\-]")[0]);
        if (majorVersion < 12) {
            throw new CacheException(String.format("Unable to restore from a backup as '%s' is no longer supported in '%s %s'", version, Version.getBrandName(), Version.getVersion()));
        }
        return properties;
    }

    private Properties readProperties(Path file, ZipFile zip) {
        Properties properties;
        block8: {
            InputStream is = zip.getInputStream(zip.getEntry(file.toString()));
            try {
                Properties props = new Properties();
                props.load(is);
                properties = props;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CacheException("Unable to read properties file", (Throwable)e);
                }
            }
            is.close();
        }
        return properties;
    }
}

