/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import org.infinispan.commons.internal.CommonsBlockHoundIntegration;
import org.infinispan.server.core.utils.SslUtils;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class ServerCoreBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside("com.sun.org.apache.xerces.internal.util.DefaultErrorHandler", "printError");
        builder.allowBlockingCallsInside("jdk.nashorn.api.scripting.NashornScriptEngineFactory", "getScriptEngine");
        ServerCoreBlockHoundIntegration.questionableBlockingMethod(builder);
        ServerCoreBlockHoundIntegration.methodsToBeRemoved(builder);
    }

    private static void questionableBlockingMethod(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(SslUtils.class.getName(), "createNettySslContext");
    }

    private static void methodsToBeRemoved(BlockHound.Builder builder) {
        try {
            CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, Class.forName("org.infinispan.scripting.impl.ScriptingManagerImpl"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        builder.allowBlockingCallsInside("org.infinispan.counter.impl.manager.EmbeddedCounterManager", "createCounter");
    }
}

