/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.scripting.logging.Log;

public final class DataTypedCacheManager
extends AbstractDelegatingEmbeddedCacheManager {
    private static final Log log = Log.getLog(DataTypedCacheManager.class);
    private final MediaType scriptMediaType;
    private final Subject subject;

    DataTypedCacheManager(MediaType scriptMediaType, EmbeddedCacheManager cm, Subject subject) {
        super(cm);
        this.scriptMediaType = scriptMediaType;
        this.subject = subject;
    }

    public <K, V> Cache<K, V> getCache() {
        throw log.scriptsCanOnlyAccessNamedCaches();
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache cache = super.getCache(cacheName);
        return cache.getAdvancedCache().withSubject(this.subject).withMediaType(this.scriptMediaType, this.scriptMediaType);
    }
}

