/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptMetadataParser;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptWithMetadata;
import org.infinispan.scripting.impl.ScriptingTaskEngine;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.scripting.utils.ScriptConversions;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.manager.TaskManager;
import org.infinispan.tasks.manager.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class ScriptingManagerImpl
implements ScriptingManager {
    private static final Log log = (Log)LogFactory.getLog(ScriptingManagerImpl.class, Log.class);
    private static final ThreadLocal<Integer> RUNNING_IN_SCRIPT = ThreadLocal.withInitial(() -> 0);
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    TaskManager taskManager;
    @Inject
    Authorizer authorizer;
    @Inject
    EncoderRegistry encoderRegistry;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    BlockingManager blockingManager;
    private ScriptEngineManager scriptEngineManager;
    private final ConcurrentMap<String, ScriptEngine> scriptEnginesByExtension = new ConcurrentHashMap<String, ScriptEngine>(2);
    private final ConcurrentMap<String, ScriptEngine> scriptEnginesByLanguage = new ConcurrentHashMap<String, ScriptEngine>(2);
    private Cache<String, String> scriptCache;
    private ScriptConversions scriptConversions;
    ConcurrentMap<String, CompiledScript> compiledScripts = new ConcurrentHashMap<String, CompiledScript>();
    private final Function<String, ScriptEngine> getEngineByName = this::getEngineByName;
    private final Function<String, ScriptEngine> getEngineByExtension = this::getEngineByExtension;

    @Start
    public void start() {
        ClassLoader classLoader = this.globalConfiguration.classLoader();
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
        this.taskManager.registerTaskEngine((TaskEngine)new ScriptingTaskEngine(this));
        this.scriptConversions = new ScriptConversions(this.encoderRegistry);
    }

    Cache<String, String> getScriptCache() {
        if (this.scriptCache == null && this.cacheManager != null) {
            this.scriptCache = SecurityActions.getCache((EmbeddedCacheManager)this.cacheManager, (String)"___script_cache");
        }
        return this.scriptCache;
    }

    CompletionStage<ScriptMetadata> compileScript(String name, String script, ScriptMetadata metadata) {
        return this.blockingManager.supplyBlocking(() -> {
            ScriptEngine engine = this.getEngineForScript(metadata);
            if (engine instanceof Compilable) {
                try {
                    CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(script);
                    this.compiledScripts.put(name, compiledScript);
                    return metadata;
                }
                catch (ScriptException e) {
                    throw log.scriptCompilationException(e, name);
                }
            }
            return null;
        }, (Object)"scripting-compile");
    }

    @Override
    public void addScript(String name, String script) {
        this.addScript(name, script, ScriptMetadataParser.parse(name, script).build());
    }

    @Override
    public void addScript(String name, String script, ScriptMetadata metadata) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(script, "script");
        Objects.requireNonNull(metadata, "metadata");
        this.getEngineForScript(metadata);
        this.getScriptCache().getAdvancedCache().put((Object)name, (Object)script, (Metadata)metadata);
    }

    @Override
    public void removeScript(String name) {
        Objects.requireNonNull(name, "name");
        if (!this.containsScript(name)) {
            throw log.noNamedScript(name);
        }
        this.getScriptCache().remove((Object)name);
    }

    @Override
    public String getScript(String name) {
        Objects.requireNonNull(name, "name");
        if (this.containsScript(name)) {
            return (String)this.getUnwrappedScriptCache().get((Object)name);
        }
        throw log.noNamedScript(name);
    }

    @Override
    public ScriptWithMetadata getScriptWithMetadata(String name) {
        Objects.requireNonNull(name, "name");
        CacheEntry entry = this.getUnwrappedScriptCache().getAdvancedCache().getCacheEntry((Object)name);
        if (entry != null) {
            return new ScriptWithMetadata((String)entry.getValue(), (ScriptMetadata)entry.getMetadata());
        }
        throw log.noNamedScript(name);
    }

    @Override
    public Set<String> getScriptNames() {
        return this.getUnwrappedScriptCache().keySet();
    }

    @Override
    public boolean containsScript(String name) {
        Objects.requireNonNull(name, "name");
        return this.getUnwrappedScriptCache().containsKey((Object)name);
    }

    CompletionStage<Boolean> containsScriptAsync(String name) {
        return this.getUnwrappedScriptCache().getAsync((Object)name).thenApply(Objects::nonNull);
    }

    private Cache<String, String> getUnwrappedScriptCache() {
        return SecurityActions.getUnwrappedCache(this.getScriptCache());
    }

    @Override
    public <T> CompletionStage<T> runScript(String name) {
        Objects.requireNonNull(name, "name");
        return this.runScript(name, new TaskContext());
    }

    @Override
    public <T> CompletionStage<T> runScript(String name, TaskContext context) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(context, "context");
        ScriptMetadata metadata = this.getScriptMetadata(name);
        if (this.authorizer != null) {
            AuthorizationManager authorizationManager;
            AuthorizationManager authorizationManager2 = authorizationManager = context.getCache().isPresent() ? SecurityActions.getCacheAuthorizationManager((AdvancedCache)((Cache)context.getCache().get()).getAdvancedCache()) : null;
            if (authorizationManager != null && !authorizationManager.isPermissive()) {
                authorizationManager.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            } else if (context.getSubject().isPresent()) {
                this.authorizer.checkPermission((Subject)context.getSubject().get(), AuthorizationPermission.EXEC);
            } else {
                this.authorizer.checkPermission(AuthorizationPermission.EXEC, (String)metadata.role().orElse(null));
            }
        }
        MediaType scriptMediaType = metadata.dataType();
        MediaType requestMediaType = context.getCache().map(c -> c.getAdvancedCache().getValueDataConversion().getRequestMediaType()).orElse(MediaType.MATCH_ALL);
        Bindings userBindings = context.getParameters().map(p -> {
            Map<String, Object> params = this.scriptConversions.convertParameters(context);
            return new SimpleBindings(params);
        }).orElse(new SimpleBindings());
        SimpleBindings systemBindings = new SimpleBindings();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, this.cacheManager, context.getSubject().orElse(null));
        systemBindings.put(SystemBindings.CACHE_MANAGER.toString(), (Object)dataTypedCacheManager);
        systemBindings.put(SystemBindings.SCRIPTING_MANAGER.toString(), (Object)this);
        context.getCache().ifPresent(cache -> {
            if (!requestMediaType.equals((Object)MediaType.MATCH_ALL)) {
                cache = cache.getAdvancedCache().withMediaType(scriptMediaType, scriptMediaType);
            }
            systemBindings.put(SystemBindings.CACHE.toString(), cache);
        });
        context.getMarshaller().ifPresent(marshaller -> systemBindings.put(SystemBindings.MARSHALLER.toString(), marshaller));
        CacheScriptBindings bindings = new CacheScriptBindings(systemBindings, userBindings);
        ScriptRunner runner = metadata.mode().getRunner();
        return runner.runScript(this, metadata, bindings).thenApply(t -> this.scriptConversions.convertToRequestType(t, metadata.dataType(), requestMediaType));
    }

    ScriptMetadata getScriptMetadata(String scriptName) {
        CacheEntry scriptEntry = SecurityActions.getCacheEntry((AdvancedCache)this.getScriptCache().getAdvancedCache(), (String)scriptName);
        if (scriptEntry == null) {
            throw log.noNamedScript(scriptName);
        }
        return (ScriptMetadata)scriptEntry.getMetadata();
    }

    <T> CompletionStage<T> execute(ScriptMetadata metadata, Bindings bindings) {
        if (RUNNING_IN_SCRIPT.get() > 0) {
            return CompletableFuture.completedFuture(this.executeDirectly(metadata, bindings));
        }
        return this.blockingManager.supplyBlocking(() -> this.executeDirectly(metadata, bindings), (Object)"ScriptingManagerImpl - execute");
    }

    private <T> T executeDirectly(ScriptMetadata metadata, Bindings bindings) {
        Integer initial = RUNNING_IN_SCRIPT.get();
        RUNNING_IN_SCRIPT.set(initial + 1);
        CompiledScript compiled = (CompiledScript)this.compiledScripts.get(metadata.name());
        try {
            if (compiled != null) {
                Object object = compiled.eval(bindings);
                return (T)object;
            }
            ScriptEngine engine = this.getEngineForScript(metadata);
            String script = (String)this.getScriptCache().get((Object)metadata.name());
            Object object = engine.eval(script, bindings);
            return (T)object;
        }
        catch (ScriptException e) {
            throw log.scriptExecutionError(e);
        }
        finally {
            RUNNING_IN_SCRIPT.set(initial);
        }
    }

    private ScriptEngine getEngineForScript(ScriptMetadata metadata) {
        ScriptEngine engine;
        Optional<String> language = metadata.language();
        if (language.isPresent() && (engine = this.scriptEnginesByLanguage.computeIfAbsent(language.get(), this.getEngineByName)) == null) {
            throw log.noScriptEngineForScript(metadata.name());
        }
        engine = this.scriptEnginesByExtension.computeIfAbsent(metadata.extension(), this.getEngineByExtension);
        if (engine == null) {
            throw log.noScriptEngineForScript(metadata.name());
        }
        return engine;
    }

    private ScriptEngine getEngineByName(String shortName) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, shortName, ScriptEngineManager::getEngineByName);
    }

    private ScriptEngine getEngineByExtension(String extension) {
        return ScriptingManagerImpl.withClassLoader(ScriptingManagerImpl.class.getClassLoader(), this.scriptEngineManager, extension, ScriptEngineManager::getEngineByExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine withClassLoader(ClassLoader cl, ScriptEngineManager manager, String name, BiFunction<ScriptEngineManager, String, ScriptEngine> f) {
        ClassLoader curr = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            ScriptEngine scriptEngine = f.apply(manager, name);
            return scriptEngine;
        }
        finally {
            Thread.currentThread().setContextClassLoader(curr);
        }
    }
}

