/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.scripting.impl.ExecutionMode;

@ProtoTypeId(value=4801)
public class ScriptMetadata
implements Metadata {
    private static final Set<String> TEXT_BASED_MEDIA = Util.asSet((Object[])new String[]{"text/plain", "application/json", "application/xml"});
    private final String name;
    private final ExecutionMode mode;
    private final String extension;
    private final Set<String> parameters;
    private final MediaType dataType;
    private final String language;
    private final String role;
    private final Map<String, String> properties;

    @ProtoFactory
    ScriptMetadata(String name, String language, String extension, ExecutionMode mode, Set<String> parameters, String role, MediaType dataType, Map<String, String> properties) {
        this.name = Objects.requireNonNull(name);
        this.language = language == null || language.isEmpty() ? null : language;
        this.extension = extension;
        this.mode = Objects.requireNonNull(mode);
        this.parameters = Collections.unmodifiableSet(parameters);
        this.role = role == null || role.isEmpty() ? null : role;
        this.dataType = dataType;
        this.properties = properties == null ? Collections.emptyMap() : Map.copyOf(properties);
    }

    @ProtoField(number=1)
    public String name() {
        return this.name;
    }

    @ProtoField(number=2)
    public ExecutionMode mode() {
        return this.mode;
    }

    @ProtoField(number=3)
    public String extension() {
        return this.extension;
    }

    @ProtoField(number=4)
    public Set<String> parameters() {
        return this.parameters;
    }

    @ProtoField(number=5)
    public MediaType dataType() {
        if (TEXT_BASED_MEDIA.contains(this.dataType.getTypeSubtype())) {
            return this.dataType.withClassType(String.class);
        }
        return this.dataType;
    }

    @ProtoField(number=6)
    public Optional<String> language() {
        return Optional.ofNullable(this.language);
    }

    @ProtoField(number=7)
    public Optional<String> role() {
        return Optional.ofNullable(this.role);
    }

    @ProtoField(number=8)
    public Map<String, String> properties() {
        return this.properties;
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return null;
    }

    public Builder builder() {
        return new Builder().name(this.name).extension(this.extension).mode(this.mode).dataType(this.dataType).language(this.language).parameters(this.parameters).role(this.role).properties(this.properties);
    }

    public String toString() {
        return "ScriptMetadata{name='" + this.name + "', mode=" + String.valueOf((Object)this.mode) + ", extension='" + this.extension + "', parameters=" + String.valueOf(this.parameters) + ", dataType=" + String.valueOf(this.dataType) + ", language=" + this.language + ", role=" + this.role + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public static class Builder
    implements Metadata.Builder {
        private String name;
        private String extension;
        private String language;
        private String role;
        private ExecutionMode mode = ExecutionMode.LOCAL;
        private Set<String> parameters = Collections.emptySet();
        private MediaType dataType = MediaType.APPLICATION_OBJECT;
        private Map<String, String> properties;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mode(ExecutionMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder parameters(Set<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder dataType(MediaType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder lifespan(long time, TimeUnit unit) {
            return this;
        }

        public Builder lifespan(long time) {
            return this;
        }

        public Builder maxIdle(long time, TimeUnit unit) {
            return this;
        }

        public Builder maxIdle(long time) {
            return this;
        }

        public Builder version(EntryVersion version) {
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.name, this.language, this.extension, this.mode, this.parameters, this.role, this.dataType, this.properties);
        }

        public Builder merge(Metadata metadata) {
            return this;
        }
    }
}

