/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.EntityLoaderFactory;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.DefaultQuerySerializer;
import org.infinispan.query.remote.impl.GlobalContextInitializerImpl;
import org.infinispan.query.remote.impl.JsonQuerySerializer;
import org.infinispan.query.remote.impl.LazySearchMapping;
import org.infinispan.query.remote.impl.ObjectRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufRemoteQueryManager;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryAccessEngine;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.persistence.PersistenceContextInitializerImpl;
import org.infinispan.query.stats.impl.LocalIndexStatistics;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.SearchMappingCommonBuilding;
import org.infinispan.tasks.query.RemoteQueryAccess;

@InfinispanModule(name="remote-query-server", requiredModules={"core", "query", "server-core"})
public final class LifecycleManager
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        org.infinispan.query.impl.LifecycleManager queryModule = (org.infinispan.query.impl.LifecycleManager)gcr.getModuleLifecycle(org.infinispan.query.impl.LifecycleManager.class);
        if (queryModule != null) {
            queryModule.enableRemoteQuery();
        }
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)org.infinispan.query.remote.client.impl.GlobalContextInitializerImpl.INSTANCE);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, GlobalContextInitializerImpl.INSTANCE);
        this.initProtobufMetadataManager(bcr);
    }

    private void initProtobufMetadataManager(BasicComponentRegistry bcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        bcr.registerComponent(ProtobufMetadataManager.class, (Object)protobufMetadataManager, true).running();
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)bcr.getComponent(ProtobufMetadataManager.class).running();
        protobufMetadataManager.getCache();
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        if (globalCfg.jmx().enabled()) {
            this.registerProtobufMetadataManagerMBean(protobufMetadataManager, globalCfg, bcr);
        }
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManagerImpl protobufMetadataManager, GlobalConfiguration globalConfig, BasicComponentRegistry bcr) {
        CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)bcr.getComponent(CacheManagerJmxRegistration.class).running();
        try {
            jmxRegistration.registerMBean((Object)protobufMetadataManager, this.getRemoteQueryGroupName(globalConfig));
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    private String getRemoteQueryGroupName(GlobalConfiguration globalConfig) {
        return "type=RemoteQuery,name=" + ObjectName.quote(globalConfig.cacheManagerName());
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr;
        BasicComponentRegistry gcr = (BasicComponentRegistry)cr.getGlobalComponentRegistry().getComponent(BasicComponentRegistry.class);
        LocalQueryStatistics queryStatistics = (LocalQueryStatistics)cr.getComponent(LocalQueryStatistics.class);
        if ("___protobuf_metadata".equals(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addProtobufMetadataManagerInterceptor((BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class));
        }
        if (!(icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class).running()).isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addCacheDependency(cacheName);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            SearchMappingCommonBuilding commonBuilding = (SearchMappingCommonBuilding)cr.getComponent(SearchMappingCommonBuilding.class);
            SearchMapping searchMapping = (SearchMapping)cr.getComponent(SearchMapping.class);
            if (commonBuilding != null && searchMapping == null) {
                AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache().withStorageMediaType();
                EntityLoaderFactory entityLoader = new EntityLoaderFactory(cache, queryStatistics);
                QueryCache queryCache = (QueryCache)cr.getGlobalComponentRegistry().getComponent(QueryCache.class);
                searchMapping = new LazySearchMapping(commonBuilding, entityLoader, serCtx, cache, protobufMetadataManager, queryCache);
                cr.registerComponent((Object)searchMapping, SearchMapping.class);
                BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
                bcr.replaceComponent(IndexStatistics.class.getName(), (Object)new LocalIndexStatistics(), true);
                bcr.rewire();
            }
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr, searchMapping);
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
            cr.registerComponent((Object)new RemoteQueryAccessEngine(), RemoteQueryAccess.class);
        }
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr, SearchMapping searchMapping) {
        boolean isObjectStorage;
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        MediaType valueStorageMediaType = valueEncoding.mediaType();
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        MediaType storageMediaType = cache.getValueDataConversion().getStorageMediaType();
        QuerySerializers querySerializers = this.buildQuerySerializers(cr, storageMediaType);
        boolean bl = isObjectStorage = valueStorageMediaType != null && valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
        if (isObjectStorage) {
            return new ObjectRemoteQueryManager(cache, cr, querySerializers);
        }
        return new ProtobufRemoteQueryManager(cache, cr, ctx, querySerializers, searchMapping);
    }

    private QuerySerializers buildQuerySerializers(ComponentRegistry cr, MediaType storageMediaType) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        QuerySerializers querySerializers = new QuerySerializers();
        DefaultQuerySerializer defaultQuerySerializer = new DefaultQuerySerializer(encoderRegistry);
        querySerializers.addSerializer(MediaType.MATCH_ALL, defaultQuerySerializer);
        if (encoderRegistry.isConversionSupported(storageMediaType, MediaType.APPLICATION_JSON)) {
            Transcoder jsonStorage = encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, storageMediaType);
            querySerializers.addSerializer(MediaType.APPLICATION_JSON, new JsonQuerySerializer(storageMediaType, jsonStorage));
        }
        return querySerializers;
    }
}

