/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.Map;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.FieldMapping;

public final class IndexingMetadata {
    public static final String INDEXED_ANNOTATION = "Indexed";
    public static final String INDEXED_INDEX_ATTRIBUTE = "index";
    public static final String YES = "YES";
    public static final String NO = "NO";
    private final boolean isIndexed;
    private final String indexName;
    private final String analyzer;
    private final Map<String, FieldMapping> fields;

    public IndexingMetadata(boolean isIndexed, String indexName, String analyzer, Map<String, FieldMapping> fields) {
        this.isIndexed = isIndexed;
        this.indexName = indexName;
        this.analyzer = analyzer;
        this.fields = fields;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public String indexName() {
        return this.indexName;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public boolean isFieldSearchable(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.searchable();
    }

    public boolean isFieldAnalyzed(String fieldName) {
        if (this.fields == null) {
            return false;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.analyzed();
    }

    public boolean isFieldNormalized(String fieldName) {
        if (this.fields == null) {
            return false;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.normalized();
    }

    public boolean isFieldProjectable(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.projectable();
    }

    public boolean isFieldAggregable(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.aggregable();
    }

    public boolean isFieldSortable(String fieldName) {
        if (this.fields == null) {
            return this.isIndexed;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null && fieldMapping.sortable();
    }

    public Object getNullMarker(String fieldName) {
        if (this.fields == null) {
            return null;
        }
        FieldMapping fieldMapping = this.fields.get(fieldName);
        return fieldMapping != null ? fieldMapping.indexNullAs() : null;
    }

    public FieldMapping getFieldMapping(String name) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(name);
    }

    public String toString() {
        return "IndexingMetadata{isIndexed=" + this.isIndexed + ", indexName='" + this.indexName + "', analyzer='" + this.analyzer + "', fields=" + String.valueOf(this.fields) + "}";
    }

    public static AnnotationElement.Annotation findAnnotation(Map<String, AnnotationElement.Annotation> annotations, String name) {
        return annotations.get(name);
    }

    public static <T> T findProcessedAnnotation(Descriptor descriptor, String name) {
        return (T)descriptor.getProcessedAnnotation(name);
    }

    public static boolean attributeMatches(AnnotationElement.Value attr, String packageName, String ... validValues) {
        String v = String.valueOf(attr.getValue());
        for (String valid : validValues) {
            if (!valid.equals(v) && !(packageName + "." + valid).equals(v)) continue;
            return true;
        }
        return false;
    }
}

