/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.core.impl.Log;

public class MassIndexerProgressMonitor {
    private static final Log log = Log.getLog(MassIndexerProgressMonitor.class);
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;
    private final TimeService timeService;

    public MassIndexerProgressMonitor(TimeService timeService) {
        this(1000, timeService);
    }

    public MassIndexerProgressMonitor(int logAfterNumberOfDocuments, TimeService timeService) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
        this.timeService = timeService;
    }

    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = this.timeService.time();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, current);
        }
    }

    public void preIndexingReloading() {
        log.preIndexingReloading();
    }

    public void indexingStarting() {
        log.indexingStarting();
    }

    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.documentsDoneCounter.get(), this.timeService.timeDuration(this.startTime, TimeUnit.MILLISECONDS));
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long doneCount) {
        log.indexingDocumentsCompleted(doneCount, this.timeService.timeDuration(startTime, TimeUnit.MILLISECONDS));
    }
}

