/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.query.BaseQuery;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.EntityLoaded;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.objectfilter.impl.syntax.parser.IckleParsingResult;

final class EmbeddedLuceneQuery<TypeMetadata, T>
extends BaseQuery<T> {
    private final QueryEngine<TypeMetadata> queryEngine;
    private final QueryEngine.RowProcessor rowProcessor;
    private final IckleParsingResult<TypeMetadata> parsingResult;
    private IndexedQuery<T> indexedQuery;
    private IndexedQuery<T> indexedListQuery;

    EmbeddedLuceneQuery(QueryEngine<TypeMetadata> queryEngine, Map<String, Object> namedParameters, IckleParsingResult<TypeMetadata> parsingResult, String[] projection, QueryEngine.RowProcessor rowProcessor, long startOffset, int maxResults, boolean local) {
        super(parsingResult.getQueryString(), namedParameters, projection, startOffset, maxResults, local);
        if (rowProcessor != null && (projection == null || projection.length == 0)) {
            throw new IllegalArgumentException("A RowProcessor can only be specified with projections");
        }
        this.queryEngine = queryEngine;
        this.rowProcessor = rowProcessor;
        this.parsingResult = parsingResult;
    }

    public void resetQuery() {
        this.indexedQuery = null;
        this.indexedListQuery = null;
    }

    public List<T> list() {
        IndexedQuery<T> indexedQuery = this.getOrCreateIndexedQuery(false);
        QueryResult<?> result = indexedQuery.execute();
        List collect = result.list().stream().map(this::convertResult).collect(Collectors.toList());
        return collect;
    }

    public QueryResult<T> execute() {
        IndexedQuery<T> indexedQuery = this.getOrCreateIndexedQuery(true);
        QueryResult<?> result = indexedQuery.execute();
        List collect = result.list().stream().map(this::convertResult).collect(Collectors.toList());
        return new QueryResultImpl(result.count(), collect);
    }

    public CompletionStage<org.infinispan.commons.api.query.QueryResult<T>> executeAsync() {
        throw new UnsupportedOperationException();
    }

    public int executeStatement() {
        IndexedQuery<T> indexedQuery = this.getOrCreateIndexedQuery(false);
        return indexedQuery.executeStatement();
    }

    public CompletionStage<Integer> executeStatementAsync() {
        throw new UnsupportedOperationException();
    }

    public CloseableIterator<T> iterator() {
        return new MappingIterator<Object, Object>(this.getOrCreateIndexedQuery(true).iterator(), this::convertResult);
    }

    public <K> ClosableIteratorWithCount<EntityEntry<K, T>> entryIterator(boolean withMetadata) {
        ClosableIteratorWithCount closableIterator = this.getOrCreateIndexedQuery(true).entryIterator(withMetadata);
        return new MappingIterator(closableIterator, null, closableIterator.count());
    }

    public int getResultSize() {
        return this.getOrCreateIndexedQuery(true).getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{queryString=" + this.queryString + ", namedParameters=" + String.valueOf(this.namedParameters) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + "}";
    }

    private IndexedQuery<T> getOrCreateIndexedQuery(boolean withHitCount) {
        if (withHitCount) {
            if (this.indexedQuery == null) {
                this.indexedQuery = this.createQuery(true);
            }
            return this.indexedQuery;
        }
        if (this.indexedListQuery == null) {
            this.indexedListQuery = this.createQuery(false);
        }
        return this.indexedListQuery;
    }

    private IndexedQuery<T> createQuery(boolean withHitCount) {
        this.validateNamedParameters();
        IndexedQuery result = this.queryEngine.buildLuceneQuery(this.parsingResult, this.namedParameters, this.startOffset, this.maxResults, this.isLocal());
        if (withHitCount) {
            if (this.hitCountAccuracy != null) {
                result = result.hitCountAccuracy(this.hitCountAccuracy);
            }
        } else {
            result.hitCountAccuracy(1);
        }
        if (this.scoreRequired) {
            result.scoreRequired();
        }
        if (this.timeout > 0L) {
            result.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        return result;
    }

    private Object convertResult(Object result) {
        Object[] array;
        if (this.projection == null) {
            if (result instanceof EntityLoaded) {
                return ((EntityLoaded)result).entity();
            }
            return result;
        }
        if (result instanceof Object[]) {
            array = (Object[])result;
        } else if (result instanceof List) {
            List castedRow = (List)result;
            array = castedRow.toArray(new Object[0]);
        } else {
            array = new Object[]{result};
        }
        return this.rowProcessor == null ? array : this.rowProcessor.apply(array);
    }
}

