/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CacheBackpressureFullException;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.objectfilter.ParsingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void keyClassNotFound(String keyClassName, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.keyClassNotFound$str(), (Object)keyClassName);
    }

    protected String keyClassNotFound$str() {
        return "ISPN014001: Could not locate key class %s";
    }

    @Override
    public final void couldNotInstantiateTransformerClass(Class<?> transformer, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotInstantiateTransformerClass$str(), transformer);
    }

    protected String couldNotInstantiateTransformerClass$str() {
        return "ISPN014002: Cannot instantiate Transformer class %s";
    }

    @Override
    public final void typeIsUsingDefaultTransformer(Class<?> keyClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.typeIsUsingDefaultTransformer$str(), keyClass);
    }

    protected String typeIsUsingDefaultTransformer$str() {
        return "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities, (Object)elapsedMs);
    }

    protected String indexingEntitiesCompleted$str() {
        return "ISPN014014: Reindexed %1$d entities in %2$d ms";
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return "ISPN014015: %1$d documents indexed in %2$d ms";
    }

    @Override
    public final void purgingIndex(String entityType) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.purgingIndex$str(), (Object)entityType);
    }

    protected String purgingIndex$str() {
        return "ISPN014016: Purging instances of '%s' from the index";
    }

    @Override
    public final void flushingIndex(String entityType) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.flushingIndex$str(), (Object)entityType);
    }

    protected String flushingIndex$str() {
        return "ISPN014017: Flushing index '%s'";
    }

    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    }

    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String groupingAndAggregationQueriesMustUseProjections$str() {
        return "ISPN014021: Queries containing grouping and aggregation functions must use projections.";
    }

    @Override
    public final ParsingException groupingAndAggregationQueriesMustUseProjections() {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.groupingAndAggregationQueriesMustUseProjections$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotHaveAggregationsInGroupByClause$str() {
        return "ISPN014022: Cannot have aggregate functions in GROUP BY clause";
    }

    @Override
    public final IllegalStateException cannotHaveAggregationsInGroupByClause() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotHaveAggregationsInGroupByClause$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multivaluedPropertyCannotBeUsedInGroupBy$str() {
        return "ISPN014023: Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported";
    }

    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInGroupBy(String propertyPath) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.multivaluedPropertyCannotBeUsedInGroupBy$str(), propertyPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multivaluedPropertyCannotBeUsedInOrderBy$str() {
        return "ISPN014024: The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued";
    }

    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInOrderBy(String propertyPath) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.multivaluedPropertyCannotBeUsedInOrderBy$str(), propertyPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String queryMustNotUseGroupingOrAggregation$str() {
        return "ISPN014025: The query must not use grouping or aggregation";
    }

    @Override
    public final IllegalStateException queryMustNotUseGroupingOrAggregation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.queryMustNotUseGroupingOrAggregation$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str() {
        return "ISPN014026: The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause";
    }

    @Override
    public final ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(String propertyPath) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str(), propertyPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multivaluedPropertyCannotBeProjected$str() {
        return "ISPN014027: The property path '%s' cannot be projected because it is multi-valued";
    }

    @Override
    public final ParsingException multivaluedPropertyCannotBeProjected(String propertyPath) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.multivaluedPropertyCannotBeProjected$str(), propertyPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResumeSuspendedTx$str() {
        return "ISPN014033: Unable to resume suspended transaction %s";
    }

    @Override
    public final CacheException unableToResumeSuspendedTx(Transaction transaction, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToResumeSuspendedTx$str(), transaction), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToSuspendTx$str() {
        return "ISPN014034: Unable to suspend transaction";
    }

    @Override
    public final CacheException unableToSuspendTx(Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToSuspendTx$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    }

    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(String s) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String partitionDegraded$str() {
        return "ISPN014042: Cannot execute query: cluster is operating in degraded mode and partition handling configuration doesn't allow reads and writes.";
    }

    @Override
    public final AvailabilityException partitionDegraded() {
        AvailabilityException result = new AvailabilityException(String.format(this.getLoggingLocale(), this.partitionDegraded$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noTransformerForKey$str() {
        return "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    }

    @Override
    public final CacheException noTransformerForKey(String keyClassName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.noTransformerForKey$str(), keyClassName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void settingBooleanQueryMaxClauseCount(String sysPropName, int maxClauseCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.settingBooleanQueryMaxClauseCount$str(), (Object)sysPropName, (Object)maxClauseCount);
    }

    protected String settingBooleanQueryMaxClauseCount$str() {
        return "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    }

    @Override
    public final void ignoringBooleanQueryMaxClauseCount(String sysPropName, int maxClauseCount, int currentMaxClauseCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringBooleanQueryMaxClauseCount$str(), (Object)sysPropName, (Object)maxClauseCount, (Object)currentMaxClauseCount);
    }

    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    }

    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return "ISPN014050: Interrupted while waiting for completions of some batch indexing operations.";
    }

    @Override
    public final CacheException interruptedWhileWaitingForRequestCompletion(Exception cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.interruptedWhileWaitingForRequestCompletion$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingEntityFailures$str() {
        return "ISPN014051: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }

    @Override
    public final String massIndexingEntityFailures(long finalFailureCount, Object firstFailureEntity, String firstFailureMessage) {
        return String.format(this.getLoggingLocale(), this.massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage);
    }

    protected String massIndexerIndexingInstance$str() {
        return "ISPN014052: Indexing instance of entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerIndexingInstance(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerIndexingInstance$str(), entityName);
    }

    protected String noTypeIsIndexed$str() {
        return "ISPN014054: Trying to execute query `%1$s`, but no type is indexed on cache.";
    }

    @Override
    public final CacheException noTypeIsIndexed(String ickle) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.noTypeIsIndexed$str(), ickle));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchMappingUnavailable$str() {
        return "ISPN014055: Cannot index entry since the search mapping failed to initialize.";
    }

    @Override
    public final CacheException searchMappingUnavailable() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.searchMappingUnavailable$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedStatement$str() {
        return "ISPN014056: Only DELETE statements are supported by executeStatement";
    }

    @Override
    public final CacheException unsupportedStatement() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unsupportedStatement$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String deleteStatementsCannotUsePaging$str() {
        return "ISPN014057: DELETE statements cannot use paging (firstResult/maxResults)";
    }

    @Override
    public final CacheException deleteStatementsCannotUsePaging() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.deleteStatementsCannotUsePaging$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String entryIteratorDoesNotAllowProjections$str() {
        return "ISPN014058: Projections are not supported with entryIterator()";
    }

    @Override
    public final CacheException entryIteratorDoesNotAllowProjections() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.entryIteratorDoesNotAllowProjections$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void mappingIsRestarting() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mappingIsRestarting$str(), new Object[0]);
    }

    protected String mappingIsRestarting$str() {
        return "ISPN014059: The indexing engine is restarting, index updates will be skipped for the current data changes.";
    }

    @Override
    public final void concurrentReindexingOnGetStatistics(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.INFO, cause, this.concurrentReindexingOnGetStatistics$str(), new Object[0]);
    }

    protected String concurrentReindexingOnGetStatistics$str() {
        return "ISPN014060: We're getting some errors from Hibernate Search or Lucene while we compute the index count/size for statistics. There is probably a concurrent reindexing ongoing.";
    }

    protected String cannotLoadIndexedClass$str() {
        return "ISPN014061: Failed to load declared indexed class '%s'";
    }

    @Override
    public final CacheConfigurationException cannotLoadIndexedClass(String name, Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotLoadIndexedClass$str(), name), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void preIndexingReloading() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.preIndexingReloading$str(), new Object[0]);
    }

    protected String preIndexingReloading$str() {
        return "ISPN014062: Search engine is reloaded before the reindexing.";
    }

    @Override
    public final void indexingStarting() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingStarting$str(), new Object[0]);
    }

    protected String indexingStarting$str() {
        return "ISPN014063: Reindexing starting.";
    }

    protected String multipleKnnPredicates$str() {
        return "ISPN014064: Multiple knn predicates are not supported at the moment.";
    }

    @Override
    public final ParsingException multipleKnnPredicates() {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.multipleKnnPredicates$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String booleanKnnPredicates$str() {
        return "ISPN014065: Boolean predicates containing knn predicates are not supported at the moment.";
    }

    @Override
    public final ParsingException booleanKnnPredicates() {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.booleanKnnPredicates$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToPurgeIndexForSegments(Throwable cause, IntSet removedSegments) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToPurgeIndexForSegments$str(), (Object)removedSegments);
    }

    protected String failedToPurgeIndexForSegments$str() {
        return "ISPN014066: Failed to purge index for segments %s";
    }

    protected String hibernateSearchBackpressure$str() {
        return "ISPN014067: Hibernate Search updates are not keeping up. Look into increasing index writer queue and/or thread pool sizes.";
    }

    @Override
    public final CacheBackpressureFullException hibernateSearchBackpressure() {
        CacheBackpressureFullException result = new CacheBackpressureFullException(String.format(this.getLoggingLocale(), this.hibernateSearchBackpressure$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void luceneBackendVersion(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.luceneBackendVersion$str(), (Object)version);
    }

    protected String luceneBackendVersion$str() {
        return "ISPN014068: Lucene version: %s";
    }

    protected String errorRetrievingTypeModel$str() {
        return "ISPN014501: Exception while retrieving the type model for '%1$s'.";
    }

    @Override
    public final SearchException errorRetrievingTypeModel(Class<?> clazz, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingTypeModel$str(), new ClassFormatter(clazz)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleEntityTypesWithSameName$str() {
        return "ISPN014502: Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'";
    }

    @Override
    public final SearchException multipleEntityTypesWithSameName(String entityName, Class<?> previousType, Class<?> type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleEntityTypesWithSameName$str(), entityName, previousType, type));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String namedTypesNotSupported$str() {
        return "ISPN014503: Infinispan Search Mapper does not support named types. The type with name '%1$s' does not exist.";
    }

    @Override
    public final SearchException namedTypesNotSupported(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedTypesNotSupported$str(), name));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadTheClass$str() {
        return "ISPN014504: Unable to load class [%1$s]";
    }

    @Override
    public final ClassLoadingException unableToLoadTheClass(String className, Throwable cause) {
        ClassLoadingException result = new ClassLoadingException(String.format(this.getLoggingLocale(), this.unableToLoadTheClass$str(), className), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEntityName$str() {
        return "ISPN014505: Unknown entity name: '%1$s'.";
    }

    @Override
    public final SearchException invalidEntityName(String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntityName$str(), entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEntitySuperType$str() {
        return "ISPN014506: Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.";
    }

    @Override
    public final SearchException invalidEntitySuperType(String entityName, Class<?> expectedSuperType, Class<?> actualJavaType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntitySuperType$str(), entityName, new ClassFormatter(expectedSuperType), new ClassFormatter(actualJavaType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void logIndexStartupModeMismatch(String data, String index, String startupMode) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.logIndexStartupModeMismatch$str(), (Object)data, (Object)index, (Object)startupMode);
    }

    protected String logIndexStartupModeMismatch$str() {
        return "ISPN014507: Data is '%s', while indexes are '%s', in the meantime the index startup mode configuration is set to '%s': this setting could lead to some inconsistency between the indexes and the data in case of restarting the nodes.";
    }
}

