/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.util.common.impl.Futures;
import org.infinispan.commons.util.ProgressTracker;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.MassIndexerProgressNotifier;
import org.infinispan.util.logging.LogFactory;

class MassIndexerProgressState {
    private static final Log LOG = (Log)LogFactory.getLog(IndexUpdater.class, Log.class);
    private final MassIndexerProgressNotifier notifier;
    private final ProgressTracker progressTracker;
    private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);

    public MassIndexerProgressState(MassIndexerProgressNotifier notifier, ProgressTracker progressTracker) {
        this.notifier = notifier;
        this.progressTracker = progressTracker;
    }

    public void addItem(Object key, Object value, CompletableFuture<?> future) {
        this.lastFuture = ((CompletableFuture)future.whenComplete((result, exception) -> {
            if (exception != null) {
                this.notifier.notifyEntityIndexingFailure(value.getClass(), key, (Throwable)exception);
            } else {
                this.notifier.notifyDocumentsAdded(1);
            }
            this.progressTracker.removeTasks(1L);
        })).thenCombine(this.lastFuture, (ignored1, ignored2) -> null);
    }

    public void waitForAsyncCompletion() {
        try {
            Futures.unwrappedExceptionGet(this.lastFuture);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw LOG.interruptedWhileWaitingForRequestCompletion(e);
        }
    }
}

