/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.work.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.impl.IndexerConfig;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.session.impl.InfinispanIndexedTypeContext;
import org.infinispan.search.mapper.session.impl.InfinispanTypeContextProvider;
import org.infinispan.search.mapper.work.SearchIndexer;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.LogFactory;

public class SearchIndexerImpl
implements SearchIndexer {
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);
    private final PojoIndexer delegate;
    private final EntityConverter entityConverter;
    private final InfinispanTypeContextProvider typeContextProvider;
    private final BlockingManager blockingManager;
    private final IndexerConfig indexerConfig;
    private final ConcurrentMap<Supplier<Flowable<?>>, CompletableFuture<?>> submittedTasks;
    private Disposable processorDisposer;
    private FlowableProcessor<Supplier<Flowable<?>>> requestProcessor;

    public SearchIndexerImpl(PojoIndexer delegate, EntityConverter entityConverter, InfinispanTypeContextProvider typeContextProvider, BlockingManager blockingManager, IndexerConfig indexerConfig) {
        this.delegate = delegate;
        this.entityConverter = entityConverter;
        this.typeContextProvider = typeContextProvider;
        this.blockingManager = blockingManager;
        this.indexerConfig = indexerConfig;
        this.submittedTasks = new ConcurrentHashMap();
    }

    @Override
    public void start() {
        this.requestProcessor = UnicastProcessor.create().toSerialized();
        this.processorDisposer = this.requestProcessor.onBackpressureDrop(supplier -> {
            CompletableFuture completableFuture = (CompletableFuture)this.submittedTasks.remove(supplier);
            if (completableFuture == null) {
                throw new IllegalStateException("Dropped task " + String.valueOf(supplier) + " not found in submittedTask " + String.valueOf(this.submittedTasks));
            }
            completableFuture.completeExceptionally((Throwable)log.hibernateSearchBackpressure());
        }).flatMap(Supplier::get, this.indexerConfig.maxConcurrency()).doFinally(this.submittedTasks::clear).subscribe(Functions.emptyConsumer(), t -> log.fatal((Object)"Indexing encountered a non recoverable error", t));
    }

    private CompletableFuture<?> sendOperation(Supplier<CompletionStage<?>> actualSupplier) {
        CompletableFuture future = new CompletableFuture();
        Supplier<Flowable> supplier = () -> {
            try {
                ((CompletionStage)actualSupplier.get()).whenCompleteAsync((v, t) -> {
                    if (t != null) {
                        future.completeExceptionally((Throwable)t);
                    } else {
                        future.complete(v);
                    }
                }, this.blockingManager.nonBlockingExecutor());
            }
            catch (Throwable t2) {
                this.blockingManager.nonBlockingExecutor().execute(() -> future.completeExceptionally(t2));
            }
            return RxJavaInterop.voidCompletionStageToFlowable((CompletionStage)future.exceptionally(CompletableFutures.toNullFunction()));
        };
        this.submittedTasks.put(supplier, future);
        future.whenComplete((v, t) -> this.submittedTasks.remove(supplier));
        this.requestProcessor.onNext(supplier);
        return future;
    }

    @Override
    public CompletableFuture<?> add(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.sendOperation(() -> this.delegate.add(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.rejecting()));
    }

    @Override
    public CompletableFuture<?> addOrUpdate(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.sendOperation(() -> this.delegate.addOrUpdate(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.rejecting()));
    }

    @Override
    public CompletableFuture<?> delete(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.sendOperation(() -> this.delegate.delete(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.rejecting()));
    }

    @Override
    public CompletableFuture<?> purge(Object providedId, String routingKey) {
        return CompletableFuture.allOf((CompletableFuture[])this.typeContextProvider.allTypeIdentifiers().stream().map(typeIdentifier -> this.sendOperation(() -> this.delegate.delete(typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.rejecting()))).toArray(CompletableFuture[]::new));
    }

    @Override
    public void close() {
        this.processorDisposer.dispose();
    }

    private ConvertedValue convertedValue(Object entity, Object providedId) {
        if (entity == null) {
            return null;
        }
        if (this.entityConverter == null || !this.entityConverter.typeIsIndexed(entity.getClass())) {
            InfinispanIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForExactType(entity.getClass());
            if (typeContext == null) {
                return null;
            }
            return new ConvertedValue(typeContext, entity);
        }
        EntityConverter.ConvertedEntity converted = this.entityConverter.convert(entity, providedId);
        if (converted.skip()) {
            return null;
        }
        InfinispanIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForEntityName(converted.entityName());
        if (typeContext == null) {
            return null;
        }
        return new ConvertedValue(typeContext, converted.value());
    }

    private static class ConvertedValue {
        private final PojoRawTypeIdentifier<?> typeIdentifier;
        private final Object value;

        public ConvertedValue(InfinispanIndexedTypeContext<?> typeContext, Object value) {
            this.typeIdentifier = typeContext.typeIdentifier();
            this.value = value;
        }
    }
}

