/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.lucene.search.TimeLimitingCollector;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.query.SearchTimeoutException;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.QueryPartitioner;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.SegmentsClusteredQueryCommand;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.util.logging.LogFactory;

final class ClusteredQueryInvoker {
    private static final Log log = (Log)LogFactory.getLog(ClusteredQueryInvoker.class, Log.class);
    private final RpcManager rpcManager;
    private final LocalQueryStatistics queryStatistics;
    private final AdvancedCache<?, ?> cache;
    private final Address myAddress;
    private final QueryPartitioner partitioner;

    ClusteredQueryInvoker(AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics) {
        this.cache = cache;
        this.rpcManager = cache.getRpcManager();
        this.queryStatistics = queryStatistics;
        this.myAddress = this.rpcManager.getAddress();
        this.partitioner = new QueryPartitioner(cache);
    }

    List<QueryResponse> broadcast(ClusteredQueryOperation operation) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        String queryString = null;
        if (log.isTraceEnabled() || this.queryStatistics.isEnabled()) {
            queryString = operation.getQueryDefinition().getQueryString();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Broadcast query started: '%s'.", (Object)queryString);
        }
        Map<Address, BitSet> split = this.partitioner.split();
        SegmentsClusteredQueryCommand localCommand = new SegmentsClusteredQueryCommand(this.cache.getName(), operation, split.get(this.myAddress));
        List futureRemoteResponses = split.entrySet().stream().filter(e -> !((Address)e.getKey()).equals((Object)this.myAddress)).map(e -> {
            Address address = (Address)e.getKey();
            BitSet segments = (BitSet)e.getValue();
            SegmentsClusteredQueryCommand cmd = new SegmentsClusteredQueryCommand(this.cache.getName(), operation, segments);
            return this.rpcManager.invokeCommand(address, (ReplicableCommand)cmd, (ResponseCollector)SingleResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
        }).map(a -> a.thenApply(r -> (QueryResponse)r.getResponseValue())).collect(Collectors.toList());
        CompletionStage<QueryResponse> localResponse = this.localInvoke(localCommand);
        ArrayList<QueryResponse> results = new ArrayList<QueryResponse>();
        try {
            results.add((QueryResponse)CompletableFutures.await(localResponse.toCompletableFuture()));
            results.addAll((Collection)CompletableFutures.await((CompletableFuture)CompletableFutures.sequence(futureRemoteResponses)));
            if (this.queryStatistics.isEnabled()) {
                this.queryStatistics.distributedIndexedQueryExecuted(queryString, System.nanoTime() - start);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Broadcast query completed: '%s'.", (Object)queryString);
            }
        }
        catch (InterruptedException e2) {
            throw new SearchException("Interrupted while searching locally", (Throwable)e2);
        }
        catch (ExecutionException e3) {
            Throwable rootCause = Util.getRootCause((Throwable)e3);
            if (rootCause instanceof org.hibernate.search.util.common.SearchTimeoutException || rootCause instanceof TimeLimitingCollector.TimeExceededException) {
                throw new SearchTimeoutException("Query exceeded timeout");
            }
            throw new SearchException("Exception while searching locally", (Throwable)e3);
        }
        return results;
    }

    private CompletionStage<QueryResponse> localInvoke(SegmentsClusteredQueryCommand cmd) {
        return cmd.perform((Cache<?, ?>)this.cache);
    }
}

