/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;

final class CQCreateEagerQuery
extends CQWorker {
    CQCreateEagerQuery() {
    }

    @Override
    CompletionStage<QueryResponse> perform(BitSet segments) {
        SearchQueryBuilder query = this.queryDefinition.getSearchQuery();
        this.setFilter(segments);
        CompletionStage<NodeTopDocs> nodeTopDocs = query.hasEntityProjection() ? this.collectKeys(query) : this.collectProjections(query);
        return nodeTopDocs.thenApply(QueryResponse::new);
    }

    private CompletionStage<NodeTopDocs> collectKeys(SearchQueryBuilder query) {
        return this.blockingManager.supplyBlocking(() -> (LuceneSearchResult)query.documentReference().fetchAll(), (Object)"CQCreateEagerQuery#collectKeys").thenApply(queryResult -> {
            if (queryResult.totalHitCount() == 0L) {
                return null;
            }
            Object[] keys = queryResult.hits().stream().map(DocumentReference::id).map(this::stringToKey).toArray(Object[]::new);
            return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), keys, null);
        });
    }

    private CompletionStage<NodeTopDocs> collectProjections(SearchQueryBuilder query) {
        return this.blockingManager.supplyBlocking(() -> (LuceneSearchResult)query.build().fetchAll(), (Object)"CQCreateEagerQuery#collectProjections").thenApply(queryResult -> {
            if (queryResult.totalHitCount() == 0L) {
                return null;
            }
            List hits = queryResult.hits();
            Object[] projections = hits.toArray(new Object[0]);
            return new NodeTopDocs(this.cache.getRpcManager().getAddress(), queryResult.topDocs(), null, projections);
        });
    }
}

