/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.impl.AndCondition;
import org.infinispan.query.dsl.impl.BooleanCondition;
import org.infinispan.query.dsl.impl.IncompleteCondition;
import org.infinispan.query.dsl.impl.OrCondition;
import org.infinispan.query.dsl.impl.Visitable;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

abstract class BaseCondition
implements FilterConditionContextQueryBuilder,
Visitable {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)BaseCondition.class.getName());
    protected BaseCondition parent = null;
    protected QueryBuilder queryBuilder;
    protected final QueryFactory queryFactory;

    protected BaseCondition(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public QueryBuilder toBuilder() {
        return this.getQueryBuilder();
    }

    QueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            throw log.subQueryDoesNotBelongToAParentQueryBuilder();
        }
        return this.queryBuilder;
    }

    void setQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder != null) {
            throw log.queryAlreadyBelongsToAnotherBuilder();
        }
        this.queryBuilder = queryBuilder;
    }

    public BaseCondition getRoot() {
        BaseCondition p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    public BaseCondition getParent() {
        return this.parent;
    }

    public void setParent(BaseCondition parent) {
        this.parent = parent;
    }

    @Override
    public FilterConditionBeginContext and() {
        IncompleteCondition rightCondition = new IncompleteCondition(this.queryFactory);
        this.combine(true, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContextQueryBuilder and(FilterConditionContext rightCondition) {
        this.combine(true, rightCondition);
        return this;
    }

    @Override
    public FilterConditionBeginContext or() {
        IncompleteCondition rightCondition = new IncompleteCondition(this.queryFactory);
        this.combine(false, rightCondition);
        return rightCondition;
    }

    @Override
    public BaseCondition or(FilterConditionContext rightCondition) {
        this.combine(false, rightCondition);
        return this;
    }

    private void combine(boolean isConjunction, FilterConditionContext fcc) {
        if (fcc == null) {
            throw log.argumentCannotBeNull();
        }
        BaseCondition rightCondition = ((BaseCondition)fcc).getRoot();
        if (rightCondition.queryFactory != this.queryFactory) {
            throw log.conditionWasCreatedByAnotherFactory();
        }
        if (rightCondition.queryBuilder != null) {
            throw log.conditionIsAlreadyInUseByAnotherBuilder();
        }
        if (isConjunction && this.parent instanceof OrCondition) {
            AndCondition p = new AndCondition(this.queryFactory, this, rightCondition);
            ((BooleanCondition)this.parent).replaceChildCondition(this, p);
            this.parent = p;
            rightCondition.setParent(p);
        } else {
            BaseCondition root = this.getRoot();
            BooleanCondition p = isConjunction ? new AndCondition(this.queryFactory, root, rightCondition) : new OrCondition(this.queryFactory, root, rightCondition);
            root.setParent(p);
            rightCondition.setParent(p);
        }
        rightCondition.setQueryBuilder(this.queryBuilder);
    }

    @Override
    public QueryBuilder startOffset(long startOffset) {
        return (QueryBuilder)this.getQueryBuilder().startOffset(startOffset);
    }

    @Override
    public QueryBuilder maxResults(int maxResults) {
        return (QueryBuilder)this.getQueryBuilder().maxResults(maxResults);
    }

    @Override
    public QueryBuilder select(Expression ... projection) {
        return this.getQueryBuilder().select(projection);
    }

    @Override
    public QueryBuilder select(String ... attributePath) {
        return this.getQueryBuilder().select(attributePath);
    }

    @Override
    public QueryBuilder groupBy(String ... attributePath) {
        return this.getQueryBuilder().groupBy(attributePath);
    }

    @Override
    public QueryBuilder orderBy(Expression expression) {
        return this.getQueryBuilder().orderBy(expression);
    }

    @Override
    public QueryBuilder orderBy(Expression expression, SortOrder sortOrder) {
        return this.getQueryBuilder().orderBy(expression);
    }

    @Override
    public QueryBuilder orderBy(String attributePath) {
        return this.getQueryBuilder().orderBy(attributePath);
    }

    @Override
    public QueryBuilder orderBy(String attributePath, SortOrder sortOrder) {
        return this.getQueryBuilder().orderBy(attributePath, sortOrder);
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        return this.getQueryBuilder().having(attributePath);
    }

    @Override
    public FilterConditionEndContext having(Expression expression) {
        return this.getQueryBuilder().having(expression);
    }

    @Override
    public FilterConditionContextQueryBuilder not() {
        return this.getQueryBuilder().not();
    }

    @Override
    public FilterConditionContextQueryBuilder not(FilterConditionContext fcc) {
        return this.getQueryBuilder().not(fcc);
    }

    @Override
    public <T> Query<T> build() {
        return this.getQueryBuilder().build();
    }
}

