/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl.eventfilter;

import java.util.Map;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.impl.QueryCache;

@ProtoTypeId(value=4216)
@Scope(value=Scopes.NONE)
public class IckleFilterAndConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, ObjectFilter.FilterResult>
implements Function<Map.Entry<K, V>, ObjectFilter.FilterResult> {
    private String cacheName;
    private QueryCache queryCache;
    private final String queryString;
    private final Map<String, Object> namedParameters;
    protected Class<? extends Matcher> matcherImplClass;
    private Matcher matcher;
    private ObjectFilter objectFilter;

    public IckleFilterAndConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (queryString == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @ProtoFactory
    protected IckleFilterAndConverter(String queryString, MarshallableMap<String, Object> wrappedNamedParameters, Class<? extends Matcher> matcherImplClass) {
        this(queryString, MarshallableMap.unwrap(wrappedNamedParameters), matcherImplClass);
    }

    @ProtoField(value=1)
    public String getQueryString() {
        return this.queryString;
    }

    @ProtoField(value=2)
    public MarshallableMap<String, Object> getWrappedNamedParameters() {
        return MarshallableMap.create(this.namedParameters);
    }

    @ProtoField(value=3)
    public Class<? extends Matcher> getMatcherImplClass() {
        return this.matcherImplClass;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry componentRegistry, QueryCache queryCache) {
        this.queryCache = queryCache;
        this.cacheName = ((AdvancedCache)componentRegistry.getCache().wired()).getName();
        this.matcher = (Matcher)componentRegistry.getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    public ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            this.objectFilter = this.queryCache != null ? this.queryCache.get(this.cacheName, this.queryString, null, this.matcherImplClass, (qs, accumulators) -> this.matcher.getObjectFilter(qs)) : this.matcher.getObjectFilter(this.queryString);
        }
        return this.namedParameters != null ? this.objectFilter.withParameters(this.namedParameters) : this.objectFilter;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public ObjectFilter.FilterResult filterAndConvert(K key, V value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(key, value, (Object)metadata);
    }

    @Override
    public ObjectFilter.FilterResult apply(Map.Entry<K, V> cacheEntry) {
        return this.filterAndConvert(cacheEntry.getKey(), cacheEntry.getValue(), (Metadata)null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{queryString='" + this.queryString + "'}";
    }
}

