/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Collection;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5310)
public final class AddManyFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Long> {
    @ProtoField(value=1)
    final boolean addOnly;
    @ProtoField(value=2)
    final boolean updateOnly;
    @ProtoField(value=3)
    final boolean updateLessScoresOnly;
    @ProtoField(value=4)
    final boolean updateGreaterScoresOnly;
    @ProtoField(value=5)
    final boolean returnChangedCount;
    @ProtoField(value=6)
    final boolean replace;
    private final Collection<ScoredValue<V>> scoredValues;

    public AddManyFunction(Collection<ScoredValue<V>> scoredValues, SortedSetAddArgs args) {
        this.scoredValues = scoredValues;
        this.addOnly = args.addOnly;
        this.updateOnly = args.updateOnly;
        this.updateLessScoresOnly = args.updateLessScoresOnly;
        this.updateGreaterScoresOnly = args.updateGreaterScoresOnly;
        this.returnChangedCount = args.returnChangedCount;
        this.replace = args.replace;
    }

    public AddManyFunction(Collection<ScoredValue<V>> scoredValues, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly, boolean returnChangedCount, boolean replace) {
        this.scoredValues = scoredValues;
        this.addOnly = addOnly;
        this.updateOnly = updateOnly;
        this.updateLessScoresOnly = updateLessScoresOnly;
        this.updateGreaterScoresOnly = updateGreaterScoresOnly;
        this.returnChangedCount = returnChangedCount;
        this.replace = replace;
    }

    @ProtoFactory
    AddManyFunction(boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly, boolean returnChangedCount, boolean replace, Collection<ScoredValue<V>> scoredValues) {
        this(scoredValues, addOnly, updateOnly, updateLessScoresOnly, updateGreaterScoresOnly, returnChangedCount, replace);
    }

    @ProtoField(value=7)
    Collection<ScoredValue<V>> getScoredValues() {
        return this.scoredValues;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        SortedSetBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (SortedSetBucket<V>)existing.get();
        } else if (!this.updateOnly || !this.replace) {
            bucket = new SortedSetBucket<V>();
        }
        if (bucket != null) {
            if (this.replace) {
                SortedSetBucket next = bucket.replace(this.scoredValues);
                if (next.size() == 0L) {
                    entryView.remove();
                } else {
                    entryView.set(next, new MetaParam.Writable[0]);
                }
                return next.size();
            }
            SortedSetBucket.SortedSetResult res = bucket.addMany(this.scoredValues, this.addOnly, this.updateOnly, this.updateLessScoresOnly, this.updateGreaterScoresOnly);
            SortedSetBucket.AddOrUpdatesCounters addResult = res.result();
            if (addResult.updated > 0L || addResult.created > 0L) {
                entryView.set(res.bucket(), new MetaParam.Writable[0]);
            }
            return this.returnChangedCount ? addResult.created + addResult.updated : addResult.created;
        }
        return 0L;
    }
}

