/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.multimap;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.function.multimap.BaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5327)
public final class PutFunction<K, V>
implements BaseFunction<K, V, Void> {
    private final V value;
    private final boolean supportsDuplicates;

    public PutFunction(V value, boolean supportsDuplicates) {
        this.value = value;
        this.supportsDuplicates = supportsDuplicates;
    }

    @ProtoFactory
    PutFunction(MarshallableObject<V> value, boolean supportsDuplicates) {
        this(MarshallableObject.unwrap(value), supportsDuplicates);
    }

    @ProtoField(value=1)
    MarshallableObject<V> getValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(value=2)
    boolean isSupportsDuplicates() {
        return this.supportsDuplicates;
    }

    public Void apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            Bucket<V> newBucket = ((Bucket)existing.get()).add(this.value, this.supportsDuplicates);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
            }
        } else {
            entryView.set(new Bucket<V>(this.value), new MetaParam.Writable[0]);
        }
        return null;
    }
}

