/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.util.Map;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5317)
public class HashMapReplaceFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Boolean> {
    private final HK property;
    private final HV expected;
    private final HV replacement;

    public HashMapReplaceFunction(HK property, HV expected, HV replacement) {
        this.property = property;
        this.expected = expected;
        this.replacement = replacement;
    }

    @ProtoFactory
    HashMapReplaceFunction(MarshallableObject<HK> property, MarshallableObject<HV> expected, MarshallableObject<HV> replacement) {
        this.property = MarshallableObject.unwrap(property);
        this.expected = MarshallableObject.unwrap(expected);
        this.replacement = MarshallableObject.unwrap(replacement);
    }

    @ProtoField(value=1)
    MarshallableObject<HK> getProperty() {
        return MarshallableObject.create(this.property);
    }

    @ProtoField(value=2)
    MarshallableObject<HV> getExpected() {
        return MarshallableObject.create(this.expected);
    }

    @ProtoField(value=3)
    MarshallableObject<HV> getReplacement() {
        return MarshallableObject.create(this.replacement);
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Optional existing = view.peek();
        HashMapBucket<HK, HV> bucket = existing.orElse(HashMapBucket.create(Map.of()));
        HashMapBucket next = bucket.replace(this.property, this.expected, this.replacement);
        if (next != null && next != bucket) {
            view.set(next, new MetaParam.Writable[0]);
        }
        return next != null;
    }
}

