/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5322)
public final class IndexOfSortedSetFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, SortedSetBucket.IndexValue> {
    private final V member;
    private final boolean isRev;

    public IndexOfSortedSetFunction(V member, boolean isRev) {
        this.member = member;
        this.isRev = isRev;
    }

    @ProtoFactory
    IndexOfSortedSetFunction(MarshallableObject<V> member, boolean rev) {
        this(MarshallableObject.unwrap(member), rev);
    }

    @ProtoField(value=1)
    MarshallableObject<V> getMember() {
        return MarshallableObject.create(this.member);
    }

    @ProtoField(value=2)
    boolean isRev() {
        return this.isRev;
    }

    public SortedSetBucket.IndexValue apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((SortedSetBucket)existing.get()).indexOf(this.member, this.isRev);
        }
        return null;
    }
}

