/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5338)
public final class SPopFunction<K, V>
implements SetBucketBaseFunction<K, V, Collection<V>> {
    @ProtoField(value=1)
    final long count;
    @ProtoField(value=2)
    final boolean remove;

    @ProtoFactory
    public SPopFunction(long count, boolean remove) {
        this.count = count;
        this.remove = remove;
    }

    public Collection<V> apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (this.count == 0L || existing.isEmpty()) {
            return Collections.emptyList();
        }
        SetBucket s = (SetBucket)existing.get();
        if (this.count > 0L) {
            Collection popped = SPopFunction.getRandomSubset(s.toList(), this.count);
            if (this.remove) {
                SetBucket.SetBucketResult result = s.removeAll(popped);
                if ((s = result.bucket()).isEmpty()) {
                    entryView.remove();
                } else {
                    entryView.set(s, new MetaParam.Writable[0]);
                }
            }
            return popped;
        }
        List list = s.toList();
        return ThreadLocalRandom.current().ints(-this.count, 0, s.size()).mapToObj(list::get).collect(Collectors.toList());
    }

    public static <T> Collection<T> getRandomSubset(List<T> list, long count) {
        if ((long)list.size() <= count) {
            return list;
        }
        Collections.shuffle(list);
        return list.stream().limit(count).collect(Collectors.toList());
    }
}

