/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.multimap;

import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.function.multimap.BaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5328)
public final class RemoveFunction<K, V>
implements BaseFunction<K, V, Boolean> {
    private final V value;
    private final boolean supportsDuplicates;

    public RemoveFunction() {
        this.value = null;
        this.supportsDuplicates = false;
    }

    public RemoveFunction(V value, boolean supportsDuplicates) {
        this.value = value;
        this.supportsDuplicates = supportsDuplicates;
    }

    @ProtoFactory
    RemoveFunction(MarshallableObject<V> value, boolean supportsDuplicates) {
        this(MarshallableObject.unwrap(value), supportsDuplicates);
    }

    @ProtoField(value=1)
    MarshallableObject<V> getValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(value=2)
    boolean isSupportsDuplicates() {
        return this.supportsDuplicates;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Boolean removed = this.value == null ? this.removeKey(entryView) : this.removeKeyValue(entryView);
        return removed;
    }

    private Boolean removeKeyValue(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        return entryView.find().map(bucket -> {
            Bucket<V> newBucket = bucket.remove(this.value, this.supportsDuplicates);
            if (newBucket != null) {
                if (newBucket.isEmpty()) {
                    entryView.remove();
                } else {
                    entryView.set(newBucket, new MetaParam.Writable[0]);
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }).orElse(Boolean.FALSE);
    }

    private Boolean removeKey(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        return entryView.find().map(values -> {
            entryView.remove();
            return Boolean.TRUE;
        }).orElse(Boolean.FALSE);
    }
}

