/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableDeque;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5331)
public final class ReplaceListFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    private final Deque<V> values;

    public ReplaceListFunction(List<V> values) {
        this(ReplaceListFunction.get(values));
    }

    public ReplaceListFunction(Deque<V> values) {
        this.values = values;
    }

    @ProtoFactory
    ReplaceListFunction(MarshallableDeque<V> values) {
        this.values = MarshallableDeque.unwrap(values);
    }

    @ProtoField(value=1)
    MarshallableDeque<V> getValues() {
        return MarshallableDeque.create(this.values);
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        ListBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (ListBucket<V>)existing.get();
        } else if (this.values != null && !this.values.isEmpty()) {
            bucket = new ListBucket<V>();
        }
        if (bucket != null) {
            ListBucket<V> updated = bucket.replace(this.values);
            if (updated.isEmpty()) {
                entryView.remove();
            } else {
                entryView.set(updated, new MetaParam.Writable[0]);
            }
            return updated.size();
        }
        return 0L;
    }

    private static <E> Deque<E> get(List<E> values) {
        block3: {
            block2: {
                if (values == null) break block2;
                if (!(values instanceof Deque)) break block3;
                Deque deque = (Deque)((Object)values);
            }
            return (Deque)((Object)values);
        }
        return new ArrayDeque<E>(values);
    }
}

