/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.multimap.impl.BaseSetBucket;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5307)
public class SortedSetBucket<V>
implements SortableBucket<V>,
BaseSetBucket<V> {
    private final TreeSet<ScoredValue<V>> scoredEntries = new TreeSet();
    private final Map<MultimapObjectWrapper<V>, Double> entries;

    @Override
    public Set<ScoredValue<V>> getAsSet() {
        return this.scoredEntries;
    }

    @Override
    public List<ScoredValue<V>> getAsList() {
        return this.getScoredEntriesAsList();
    }

    @Override
    public Double getScore(MultimapObjectWrapper<V> key) {
        return this.entries.get(key);
    }

    public List<ScoredValue<V>> randomMembers(int count) {
        if (count == 1 || count == -1) {
            int rank = ThreadLocalRandom.current().nextInt(this.scoredEntries.size());
            return this.subsetByIndex(rank, rank, false);
        }
        if (count < 0) {
            int totalCount = Math.abs(count);
            ArrayList<ScoredValue<V>> randomEntries = new ArrayList<ScoredValue<V>>(totalCount);
            ThreadLocalRandom.current().ints(totalCount, 0, this.entries.size()).forEach(randomPos -> randomEntries.add(this.subsetByIndex(randomPos, randomPos, false).get(0)));
            return randomEntries;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>(this.entries.size());
        while (positions.size() < this.entries.size()) {
            positions.add(positions.size());
        }
        Collections.shuffle(positions);
        ArrayList<ScoredValue<V>> randomEntries = new ArrayList<ScoredValue<V>>();
        Iterator ite = positions.iterator();
        while (randomEntries.size() < count && randomEntries.size() < this.entries.size()) {
            Integer pos = (Integer)ite.next();
            randomEntries.add(this.subsetByIndex(pos.intValue(), pos.intValue(), false).get(0));
        }
        return randomEntries;
    }

    @ProtoFactory
    SortedSetBucket(Collection<ScoredValue<V>> wrappedValues) {
        this.scoredEntries.addAll(wrappedValues);
        this.entries = new HashMap<MultimapObjectWrapper<V>, Double>();
        wrappedValues.forEach(e -> this.entries.put(e.wrappedValue(), e.score()));
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<ScoredValue<V>> getWrappedValues() {
        return new ArrayList<ScoredValue<V>>(this.scoredEntries);
    }

    public SortedSet<ScoredValue<V>> getScoredEntries() {
        return new TreeSet<ScoredValue<V>>(this.scoredEntries);
    }

    public List<ScoredValue<V>> getScoredEntriesAsList() {
        return new ArrayList<ScoredValue<V>>(this.scoredEntries);
    }

    public SortedSetBucket() {
        this.entries = new HashMap<MultimapObjectWrapper<V>, Double>();
    }

    public SortedSetResult<Collection<ScoredValue<V>>, V> pop(boolean min, long count) {
        Iterator<ScoredValue<V>> it = min ? this.scoredEntries.iterator() : this.scoredEntries.descendingIterator();
        int i = 0;
        ArrayList<ScoredValue<V>> popped = new ArrayList<ScoredValue<V>>();
        ArrayList<ScoredValue<V>> remaining = new ArrayList<ScoredValue<V>>();
        while (it.hasNext()) {
            ScoredValue<V> sv = it.next();
            if ((long)(++i) > count) {
                remaining.add(sv);
                continue;
            }
            popped.add(sv);
        }
        return new SortedSetResult(popped, new SortedSetBucket<V>(remaining));
    }

    public List<Double> scores(List<V> members) {
        return members.stream().map(m -> this.entries.get(new MultimapObjectWrapper<Object>(m))).collect(Collectors.toList());
    }

    public IndexValue indexOf(V member, boolean isRev) {
        MultimapObjectWrapper<V> wrapMember = new MultimapObjectWrapper<V>(member);
        Double score = this.entries.get(wrapMember);
        if (score == null) {
            return null;
        }
        SortedSet<ScoredValue<V>> tailedHead = this.scoredEntries.headSet(new ScoredValue<V>(score, wrapMember));
        return isRev ? IndexValue.of(score, this.scoredEntries.size() - tailedHead.size() - 1) : IndexValue.of(score, tailedHead.size());
    }

    public SortedSetBucket<V> replace(Collection<ScoredValue<V>> scoredValues) {
        return new SortedSetBucket<V>(scoredValues);
    }

    public SortedSetResult<AddOrUpdatesCounters, V> addMany(Collection<ScoredValue<V>> scoredValues, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly) {
        AddOrUpdatesCounters addResult = new AddOrUpdatesCounters();
        SortedSetBucket<V> next = new SortedSetBucket<V>(this.scoredEntries);
        long startSize = next.size();
        for (ScoredValue<V> scoredValue : scoredValues) {
            if (addOnly) {
                next.addOnly(scoredValue);
                continue;
            }
            if (updateOnly && !updateGreaterScoresOnly && !updateLessScoresOnly) {
                next.updateOnly(addResult, scoredValue);
                continue;
            }
            if (updateGreaterScoresOnly) {
                next.addOrUpdateGreaterScores(updateOnly, addResult, scoredValue);
                continue;
            }
            if (updateLessScoresOnly) {
                next.addOrUpdateLessScores(updateOnly, addResult, scoredValue);
                continue;
            }
            next.addOrUpdate(addResult, scoredValue);
        }
        addResult.created = next.size() - startSize;
        return new SortedSetResult<AddOrUpdatesCounters, V>(addResult, next);
    }

    public SortedSetResult<Double, V> incrScore(double incr, V member, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly) {
        MultimapObjectWrapper<V> wrappedValue = new MultimapObjectWrapper<V>(member);
        Double existingScore = this.entries.get(wrappedValue);
        if (existingScore != null && addOnly || existingScore == null && updateOnly) {
            return null;
        }
        Double newScore = existingScore == null ? incr : existingScore + incr;
        if (existingScore != null) {
            if (updateGreaterScoresOnly && newScore <= existingScore || updateLessScoresOnly && newScore >= existingScore) {
                return null;
            }
            if (Double.isNaN(newScore)) {
                throw new IllegalStateException("resulting score is not a number (NaN)");
            }
        }
        SortedSetBucket<V> next = new SortedSetBucket<V>(this.scoredEntries);
        next.addOrUpdate(new AddOrUpdatesCounters(), new ScoredValue<V>(newScore, wrappedValue));
        return new SortedSetResult<Double, V>(newScore, next);
    }

    private void addOnly(ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        }
    }

    private void updateOnly(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore != null && !existingScore.equals(scoredValue.score())) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdateGreaterScores(boolean updateOnly, AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null && !updateOnly) {
            this.addScoredValue(scoredValue);
        } else if (existingScore != null && scoredValue.score() > existingScore) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdateLessScores(boolean updateOnly, AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null && !updateOnly) {
            this.addScoredValue(scoredValue);
        } else if (existingScore != null && scoredValue.score() < existingScore) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdate(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        } else if (!scoredValue.score().equals(existingScore)) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void updateScoredValue(ScoredValue<V> newScoredValue, Double existingScore) {
        ScoredValue<V> oldScoredValue = new ScoredValue<V>(existingScore, newScoredValue.wrappedValue());
        this.scoredEntries.remove(oldScoredValue);
        this.scoredEntries.add(newScoredValue);
        this.entries.put(newScoredValue.wrappedValue(), newScoredValue.score());
    }

    private void addScoredValue(ScoredValue<V> scoredValue) {
        this.scoredEntries.add(scoredValue);
        this.entries.put(scoredValue.wrappedValue(), scoredValue.score());
    }

    public SortedSetResult<Long, V> removeAll(Collection<V> values) {
        ArrayList<ScoredValue<V>> subset = new ArrayList<ScoredValue<V>>();
        for (V value : values) {
            MultimapObjectWrapper<V> wrappedValue = new MultimapObjectWrapper<V>(value);
            Double score = this.entries.get(wrappedValue);
            if (score == null) continue;
            subset.add(new ScoredValue<V>(score, wrappedValue));
        }
        return this.removeAllInternal(subset);
    }

    public SortedSetResult<Long, V> removeAll(V min, boolean includeMin, V max, boolean includeMax) {
        List<ScoredValue<V>> subset = this.subset(min, includeMin, max, includeMax, false, null, null);
        return this.removeAllInternal(subset);
    }

    public SortedSetResult<Long, V> removeAll(Double min, boolean includeMin, Double max, boolean includeMax) {
        List<ScoredValue<V>> subset = this.subset((V)min, includeMin, (V)max, includeMax, false, null, null);
        return this.removeAllInternal(subset);
    }

    public SortedSetResult<Long, V> removeAll(Long min, Long max) {
        List<ScoredValue<V>> subset = this.subsetByIndex(min, max, false);
        return this.removeAllInternal(subset);
    }

    private SortedSetResult<Long, V> removeAllInternal(Collection<ScoredValue<V>> subset) {
        if (subset.isEmpty()) {
            return new SortedSetResult(0L, this);
        }
        ArrayList<ScoredValue<V>> remaining = new ArrayList<ScoredValue<V>>(this.scoredEntries.size());
        for (ScoredValue<V> sv : this.scoredEntries) {
            if (subset.contains(sv)) continue;
            remaining.add(sv);
        }
        long size = subset.size();
        return new SortedSetResult<Long, V>(size, new SortedSetBucket<V>(remaining));
    }

    public List<ScoredValue<V>> subsetByIndex(long from, long to, boolean rev) {
        long pos;
        long toIte;
        if (from > 0L && to > 0L && from > to || from < 0L && to < 0L && from > to) {
            return Collections.emptyList();
        }
        long fromIte = from < 0L ? (long)this.scoredEntries.size() + from : from;
        long l = toIte = to < 0L ? (long)this.scoredEntries.size() + to : to;
        if (fromIte > toIte) {
            return Collections.emptyList();
        }
        ArrayList<ScoredValue<V>> results = new ArrayList<ScoredValue<V>>();
        Iterator<ScoredValue<V>> ite = rev ? this.scoredEntries.descendingIterator() : this.scoredEntries.iterator();
        for (pos = 0L; pos < fromIte && ite.hasNext(); ++pos) {
            ite.next();
        }
        while (pos <= toIte && ite.hasNext()) {
            results.add(ite.next());
            ++pos;
        }
        return results;
    }

    public List<ScoredValue<V>> subset(Double startScore, boolean includeStart, Double stopScore, boolean includeStop, boolean isRev, Long offset, Long count) {
        ScoredValue<V> stopSv;
        ScoredValue<V> startSv;
        boolean unboundedMax;
        if (stopScore != null && stopScore.equals(startScore) && (!includeStart || !includeStop) || count != null && count == 0L || offset != null && offset.equals(this.entries.size())) {
            return Collections.emptyList();
        }
        Double min = isRev ? stopScore : startScore;
        boolean includeMin = isRev ? includeStop : includeStart;
        Double max = isRev ? startScore : stopScore;
        boolean includeMax = isRev ? includeStart : includeStop;
        boolean unboundedMin = min == null || min == Double.MIN_VALUE;
        boolean bl = unboundedMax = max == null || max == Double.MAX_VALUE;
        if (unboundedMin && unboundedMax) {
            return this.applyLimit(this.scoredEntries, offset, count, isRev);
        }
        if (unboundedMin) {
            startSv = this.scoredEntries.first();
        } else if (includeMin) {
            startSv = this.scoredEntries.lower(ScoredValue.of(min));
            if (startSv == null) {
                startSv = this.scoredEntries.first();
            }
        } else {
            startSv = this.scoredEntries.higher(ScoredValue.of(min));
            if (startSv == null) {
                startSv = this.scoredEntries.last();
            }
        }
        if (unboundedMax) {
            stopSv = this.scoredEntries.last();
        } else {
            stopSv = includeMax ? this.scoredEntries.higher(ScoredValue.of(max)) : this.scoredEntries.lower(ScoredValue.of(max));
            if (stopSv == null) {
                stopSv = this.scoredEntries.last();
            }
        }
        if (startSv.score() > stopSv.score()) {
            return Collections.emptyList();
        }
        NavigableSet<ScoredValue<V>> subset = this.scoredEntries.subSet(startSv, unboundedMin || startSv.score() > min || includeMin && startSv.score().equals(min), stopSv, unboundedMax || stopSv.score() < max || includeMax && stopSv.score().equals(max));
        return this.applyLimit(subset, offset, count, isRev);
    }

    public List<ScoredValue<V>> subset(V startValue, boolean includeStart, V stopValue, boolean includeStop, boolean isRev, Long offset, Long count) {
        boolean unboundedMax;
        boolean includeMax;
        V minValue = isRev ? stopValue : startValue;
        V maxValue = isRev ? startValue : stopValue;
        boolean includeMin = isRev ? includeStop : includeStart;
        boolean bl = includeMax = isRev ? includeStart : includeStop;
        if (maxValue != null && maxValue.equals(minValue) && (!includeMin || !includeMax) || offset != null && offset.equals(this.entries.size()) || count != null && count == 0L) {
            return Collections.emptyList();
        }
        boolean unboundedMin = minValue == null;
        boolean bl2 = unboundedMax = maxValue == null;
        if (unboundedMin && unboundedMax) {
            return this.applyLimit(this.scoredEntries, offset, count, isRev);
        }
        double score = this.scoredEntries.first().score();
        ScoredValue<V> minScoredValue = ScoredValue.of(score, minValue);
        ScoredValue<V> maxScoredValue = ScoredValue.of(score, maxValue);
        if (unboundedMin) {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.headSet(maxScoredValue, includeMax);
            return this.applyLimit(entries, offset, count, isRev);
        }
        if (unboundedMax) {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.tailSet(minScoredValue, includeMin);
            return this.applyLimit(entries, offset, count, isRev);
        }
        try {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.subSet(minScoredValue, includeMin, maxScoredValue, includeMax);
            return this.applyLimit(entries, offset, count, isRev);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    private List<ScoredValue<V>> applyLimit(NavigableSet<ScoredValue<V>> subset, Long offset, Long count, boolean isRev) {
        Iterator<ScoredValue<V>> ite;
        if (!SortedSetBucket.isLimited(offset, count)) {
            Iterator<ScoredValue<V>> ite2;
            ArrayList<ScoredValue<V>> result = new ArrayList<ScoredValue<V>>(this.entries.size());
            Iterator<ScoredValue<V>> iterator = ite2 = isRev ? subset.descendingIterator() : subset.iterator();
            while (ite2.hasNext()) {
                result.add(ite2.next());
            }
            return result;
        }
        ArrayList<ScoredValue<V>> result = new ArrayList<ScoredValue<V>>();
        Iterator<ScoredValue<V>> iterator = ite = isRev ? subset.descendingIterator() : subset.iterator();
        if (count < 0L) {
            this.skipOffset(offset, ite);
            while (ite.hasNext()) {
                result.add(ite.next());
            }
        } else {
            this.skipOffset(offset, ite);
            long localCount = 0L;
            while (ite.hasNext() && localCount++ < count) {
                result.add(ite.next());
            }
        }
        return result;
    }

    private void skipOffset(Long offset, Iterator<ScoredValue<V>> ite) {
        long localOffset = 0L;
        while (localOffset++ < offset && ite.hasNext()) {
            ite.next();
        }
    }

    private static boolean isLimited(Long offset, Long count) {
        return offset != null && count != null;
    }

    public Collection<ScoredValue<V>> toTreeSet() {
        return new TreeSet<ScoredValue<V>>(this.scoredEntries);
    }

    public long size() {
        return this.scoredEntries.size();
    }

    @Override
    public Stream<MultimapObjectWrapper<V>> stream() {
        return this.scoredEntries.stream().map(ScoredValue::wrappedValue);
    }

    @Override
    public List<ScoredValue<V>> sort(SortableBucket.SortOptions sortOptions) {
        if (sortOptions.skipSort) {
            return this.getScoredEntriesAsList();
        }
        Stream scoredValueStream = sortOptions.alpha ? this.scoredEntries.stream().map(v -> new ScoredValue(1.0, v.wrappedValue())) : this.scoredEntries.stream().map(v -> new ScoredValue(v.wrappedValue().asDouble(), v.wrappedValue()));
        return this.sort(scoredValueStream, sortOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedSetBucket that = (SortedSetBucket)o;
        return Objects.equals(this.scoredEntries, that.scoredEntries) && Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.scoredEntries, this.entries);
    }

    public record SortedSetResult<R, E>(R result, SortedSetBucket<E> bucket) {
    }

    @ProtoTypeId(value=5309)
    public static class IndexValue {
        @ProtoField(number=1, defaultValue="0")
        final double score;
        @ProtoField(number=2, defaultValue="0")
        final long index;

        @ProtoFactory
        IndexValue(double score, long index) {
            this.score = score;
            this.index = index;
        }

        public static IndexValue of(double score, long index) {
            return new IndexValue(score, index);
        }

        public long getValue() {
            return this.index;
        }

        public double getScore() {
            return this.score;
        }
    }

    public static class AddOrUpdatesCounters {
        public long created = 0L;
        public long updated = 0L;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Proto
    @ProtoTypeId(value=5344)
    public static enum AggregateFunction {
        SUM{

            @Override
            public double apply(double first, double second) {
                return first + second;
            }
        }
        ,
        MIN{

            @Override
            public double apply(double first, double second) {
                return Math.min(first, second);
            }
        }
        ,
        MAX{

            @Override
            public double apply(double first, double second) {
                return Math.max(first, second);
            }
        };


        public abstract double apply(double var1, double var3);
    }
}

