/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5323)
public final class InsertFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    private final boolean before;
    private final V pivot;
    private final V element;

    public InsertFunction(boolean before, V pivot, V element) {
        this.before = before;
        this.pivot = pivot;
        this.element = element;
    }

    @ProtoFactory
    InsertFunction(boolean before, MarshallableObject<V> pivot, MarshallableObject<V> element) {
        this(before, MarshallableObject.unwrap(pivot), MarshallableObject.unwrap(element));
    }

    @ProtoField(value=1)
    boolean isBefore() {
        return this.before;
    }

    @ProtoField(value=2)
    MarshallableObject<V> getPivot() {
        return MarshallableObject.create(this.pivot);
    }

    @ProtoField(value=3)
    MarshallableObject<V> getElement() {
        return MarshallableObject.create(this.element);
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> bucket = ((ListBucket)existing.get()).insert(this.before, this.pivot, this.element);
            if (bucket == null) {
                return -1L;
            }
            entryView.set(bucket, new MetaParam.Writable[0]);
            return bucket.size();
        }
        return 0L;
    }
}

