/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5319)
public final class IncrFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Double> {
    @ProtoField(value=1)
    final Double score;
    @ProtoField(value=2)
    final boolean addOnly;
    @ProtoField(value=3)
    final boolean updateOnly;
    @ProtoField(value=4)
    final boolean updateLessScoresOnly;
    @ProtoField(value=5)
    final boolean updateGreaterScoresOnly;
    private final V member;

    public IncrFunction(double score, V member, SortedSetAddArgs args) {
        this.score = score;
        this.member = member;
        this.addOnly = args.addOnly;
        this.updateOnly = args.updateOnly;
        this.updateLessScoresOnly = args.updateLessScoresOnly;
        this.updateGreaterScoresOnly = args.updateGreaterScoresOnly;
    }

    @ProtoFactory
    public IncrFunction(Double score, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly, MarshallableObject<V> member) {
        this.score = score;
        this.addOnly = addOnly;
        this.updateOnly = updateOnly;
        this.updateLessScoresOnly = updateLessScoresOnly;
        this.updateGreaterScoresOnly = updateGreaterScoresOnly;
        this.member = MarshallableObject.unwrap(member);
    }

    @ProtoField(value=6)
    MarshallableObject<V> getMember() {
        return MarshallableObject.create(this.member);
    }

    public Double apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        SortedSetBucket.SortedSetResult res;
        Optional existing = entryView.peek();
        SortedSetBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (SortedSetBucket<V>)existing.get();
        } else if (!this.updateOnly) {
            bucket = new SortedSetBucket<V>();
        }
        Double result = null;
        if (bucket != null && (res = bucket.incrScore(this.score, this.member, this.addOnly, this.updateOnly, this.updateLessScoresOnly, this.updateGreaterScoresOnly)) != null) {
            result = res.result();
            entryView.set(res.bucket(), new MetaParam.Writable[0]);
        }
        return result;
    }
}

