/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5340)
public final class SetFunction<K, V>
implements ListBucketBaseFunction<K, V, Boolean> {
    @ProtoField(value=1)
    final long index;
    private final V value;

    public SetFunction(long index, V value) {
        this.index = index;
        this.value = value;
    }

    @ProtoFactory
    SetFunction(long index, MarshallableObject<V> value) {
        this(index, MarshallableObject.unwrap(value));
    }

    @ProtoField(value=2)
    MarshallableObject<V> getValue() {
        return MarshallableObject.create(this.value);
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> newBucket = ((ListBucket)existing.get()).set(this.index, this.value);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
                return true;
            }
            throw new CacheException((Throwable)new IndexOutOfBoundsException("Index is out of range"));
        }
        return false;
    }
}

