/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5325)
public final class PollFunction<K, V>
implements ListBucketBaseFunction<K, V, Collection<V>> {
    @ProtoField(value=1)
    final boolean first;
    @ProtoField(value=2)
    final long count;

    @ProtoFactory
    public PollFunction(boolean first, long count) {
        this.first = first;
        this.count = count;
    }

    public Collection<V> apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            if (this.count == 0L) {
                return List.of();
            }
            ListBucket.ListBucketResult result = ((ListBucket)existing.get()).poll(this.first, this.count);
            if (result.bucket().isEmpty()) {
                entryView.remove();
            } else {
                entryView.set(result.bucket(), new MetaParam.Writable[0]);
            }
            return result.result();
        }
        return null;
    }
}

