/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.function.multimap.ContainsFunction;
import org.infinispan.multimap.impl.function.multimap.GetFunction;
import org.infinispan.multimap.impl.function.multimap.PutFunction;
import org.infinispan.multimap.impl.function.multimap.RemoveFunction;
import org.infinispan.reactive.publisher.PublisherReducers;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializablePredicate;
import org.reactivestreams.Publisher;

public class EmbeddedMultimapCache<K, V>
implements MultimapCache<K, V> {
    private final FunctionalMap.ReadWriteMap<K, Bucket<V>> readWriteMap;
    private final AdvancedCache<K, Bucket<V>> cache;
    private final InternalEntryFactory entryFactory;
    private final boolean supportsDuplicates;

    public EmbeddedMultimapCache(Cache<K, Bucket<V>> cache, boolean supportsDuplicates) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)ComponentRegistry.of(this.cache).getInternalEntryFactory().running();
        this.supportsDuplicates = supportsDuplicates;
    }

    public CompletableFuture<Void> put(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new PutFunction(value, this.supportsDuplicates));
    }

    public CompletableFuture<Collection<V>> get(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new GetFunction(this.supportsDuplicates));
    }

    @Override
    public CompletableFuture<Optional<CacheEntry<K, Collection<V>>>> getEntry(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.cache.getAdvancedCache().getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return Optional.empty();
            }
            return Optional.of(this.entryFactory.create(entry.getKey(), this.supportsDuplicates ? ((Bucket)entry.getValue()).toList() : ((Bucket)entry.getValue()).toSet(), entry.getMetadata()));
        });
    }

    public CompletableFuture<Boolean> remove(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction());
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction(value, this.supportsDuplicates));
    }

    @Override
    public CompletableFuture<Void> remove(Predicate<? super V> p) {
        Objects.requireNonNull(p, "predicate can't be null");
        return this.removeInternal(p).toCompletableFuture();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction());
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        Objects.requireNonNull(value, "value can't be null");
        return this.containsEntryInternal(value).toCompletableFuture();
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction(value));
    }

    public CompletableFuture<Long> size() {
        return this.sizeInternal().toCompletableFuture();
    }

    private CompletionStage<Void> removeInternal(Predicate<? super V> p) {
        Publisher keyPublisher = this.cache.cachePublisher().entryPublisher((SerializableFunction & Serializable)publisher -> Flowable.fromPublisher((Publisher)publisher).filter(ce -> {
            for (Object v : ((Bucket)ce.getValue()).values) {
                if (!p.test((Object)v)) continue;
                return true;
            }
            return false;
        }).map(CacheEntry::getKey)).publisherWithoutSegments();
        return Flowable.fromPublisher((Publisher)keyPublisher).concatMapCompletable(key -> Completable.fromCompletionStage((CompletionStage)this.cache.computeIfPresentAsync(key, (SerializableBiFunction & Serializable)(k, bucket) -> {
            Bucket newBucket = bucket.removeIf(p);
            if (newBucket == null) {
                return bucket;
            }
            return newBucket.isEmpty() ? null : newBucket;
        }))).toCompletionStage(null);
    }

    private CompletionStage<Boolean> containsEntryInternal(V value) {
        SerializablePredicate & Serializable func = (SerializablePredicate & Serializable)entry -> ((Bucket)entry.getValue()).contains(value);
        return this.cache.cachePublisher().atLeastOnce().entryReduction(PublisherReducers.anyMatch((Predicate)func), PublisherReducers.or());
    }

    private CompletionStage<Long> sizeInternal() {
        SerializableBiFunction & Serializable func = (SerializableBiFunction & Serializable)(sum, entry) -> sum + (long)((Bucket)entry.getValue()).size();
        return this.cache.cachePublisher().entryReduction(PublisherReducers.reduce((Object)0L, (BiFunction)func), PublisherReducers.add());
    }

    public boolean supportsDuplicates() {
        return this.supportsDuplicates;
    }

    public Cache<K, Bucket<V>> getCache() {
        return this.cache;
    }
}

