/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.jcache.remote.LocalStatistics;
import org.infinispan.jcache.remote.RemoteCacheWrapper;

public class RemoteCacheWithStats<K, V>
extends RemoteCacheWrapper<K, V> {
    private LocalStatistics stats;

    public RemoteCacheWithStats(RemoteCache<K, V> delegate, LocalStatistics stats) {
        super(delegate);
        this.stats = stats;
    }

    @Override
    public V get(Object key) {
        Object v = this.delegate.get(key);
        if (v == null) {
            this.stats.incrementCacheMisses();
        } else {
            this.stats.incrementCacheHits();
        }
        this.stats.incrementCacheGets();
        return (V)v;
    }

    @Override
    public V put(K key, V value) {
        Object v = this.delegate.put(key, value);
        this.stats.incrementCachePuts();
        return (V)v;
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Object v = this.delegate.put(key, value, lifespan, unit);
        this.stats.incrementCachePuts();
        return (V)v;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object result = this.delegate.putIfAbsent(key, value);
        if (result == null) {
            this.stats.incrementCachePuts();
        }
        return (V)result;
    }

    @Override
    public V replace(K key, V value) {
        Object v = this.delegate.replace(key, value);
        if (v != null) {
            this.stats.incrementCacheHits();
            this.stats.incrementCachePuts();
        } else {
            this.stats.incrementCacheMisses();
        }
        return (V)v;
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version) {
        boolean replaced = this.delegate.replaceWithVersion(key, newValue, version);
        if (replaced) {
            this.stats.incrementCachePuts();
        }
        return replaced;
    }

    @Override
    public V remove(Object key) {
        Object v = this.delegate.remove(key);
        if (v != null) {
            this.stats.incrementCacheRemovals();
        }
        return (V)v;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        boolean removed = this.delegate.removeWithVersion(key, version);
        if (removed) {
            this.stats.incrementCacheRemovals();
        }
        return removed;
    }
}

