/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jboss.marshalling;

import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.jboss.marshalling.dataconversion.JBossMarshallingTranscoder;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;

@InfinispanModule(name="jboss-marshalling", requiredModules={"core"})
public class JbossMarshallingModule
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        Marshaller userMarshaller = globalConfiguration.serialization().marshaller();
        if (userMarshaller instanceof JBossUserMarshaller) {
            ((JBossUserMarshaller)userMarshaller).initialize(gcr);
        } else {
            ClassAllowList classAllowList = ((EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class)).getClassAllowList();
            ClassLoader classLoader = globalConfiguration.classLoader();
            GenericJBossMarshaller jbossMarshaller = new GenericJBossMarshaller(classLoader, classAllowList);
            EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
            encoderRegistry.registerTranscoder((Transcoder)new JBossMarshallingTranscoder(jbossMarshaller));
        }
    }
}

