/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v6.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.v6.impl.Invocation;

public class FutureUpdateInvocation
implements Invocation,
BiFunction<Void, Throwable, Void> {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(FutureUpdateInvocation.class);
    private final UUID uuid = Util.threadLocalRandomUUID();
    private final Object key;
    private final Object value;
    private final InfinispanDataRegion region;
    private final long sessionTimestamp;
    private final FunctionalMap.ReadWriteMap<Object, Object> rwMap;
    private final CompletableFuture<Void> future = new CompletableFuture();

    public FutureUpdateInvocation(FunctionalMap.ReadWriteMap<Object, Object> rwMap, Object key, Object value, InfinispanDataRegion region, long sessionTimestamp) {
        this.rwMap = rwMap;
        this.key = key;
        this.value = value;
        this.region = region;
        this.sessionTimestamp = sessionTimestamp;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public CompletableFuture<Void> invoke(boolean success) {
        if (this.sessionTimestamp < this.region.getLastRegionInvalidation()) {
            success = false;
        }
        FutureUpdate futureUpdate = new FutureUpdate(this.uuid, this.region.nextTimestamp(), success ? this.value : null);
        while (true) {
            try {
                this.rwMap.eval(this.key, (Function)futureUpdate).handle((BiFunction)this);
                return this.future;
            }
            catch (Exception e) {
                log.failureInAfterCompletion((Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    public Void apply(Void nil, Throwable throwable) {
        if (throwable != null) {
            log.failureInAfterCompletion(throwable);
            this.invoke(false);
        } else {
            this.future.complete(null);
        }
        return null;
    }
}

