/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v6.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.v6.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v6.impl.BaseRegionImpl;
import org.infinispan.hibernate.cache.v6.impl.Invocation;
import org.infinispan.hibernate.cache.v6.impl.Sync;

public final class QueryResultsRegionImpl
extends BaseRegionImpl
implements QueryResultsRegion {
    private final AdvancedCache<Object, Object> putCache;
    private final AdvancedCache<Object, Object> getCache;
    private final ConcurrentMap<Object, Map> transactionContext = new ConcurrentHashMap<Object, Map>();

    public QueryResultsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        boolean localOnly = Caches.isInvalidationCache((AdvancedCache)cache);
        this.putCache = localOnly ? Caches.failSilentWriteCache((AdvancedCache)cache, (Flag)Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache((AdvancedCache)cache);
        this.getCache = Caches.failSilentReadCache((AdvancedCache)cache);
    }

    @Override
    public void clear() throws CacheException {
        this.transactionContext.clear();
        this.invalidateRegion();
        Caches.broadcastEvictAll((AdvancedCache)this.cache);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (!this.checkValid()) {
            return null;
        }
        Object result = null;
        Map map = (Map)this.transactionContext.get(session);
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = this.getCache.get(key);
        }
        return result;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        if (!this.checkValid()) {
            return;
        }
        Sync sync = (Sync)session.getCacheTransactionSynchronization();
        if (sync != null && session.isTransactionInProgress()) {
            sync.registerAfterCommit(new PostTransactionQueryUpdate(session, key, value));
            this.transactionContext.computeIfAbsent(session, k -> new HashMap()).put(key, value);
        } else {
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    implements Invocation {
        private final Object session;
        private final Object key;
        private final Object value;

        PostTransactionQueryUpdate(Object session, Object key, Object value) {
            this.session = session;
            this.key = key;
            this.value = value;
        }

        public CompletableFuture<Object> invoke(boolean success) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            if (success) {
                return QueryResultsRegionImpl.this.putCache.putAsync(this.key, this.value);
            }
            return null;
        }
    }
}

