/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v6.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.v6.impl.FutureUpdateInvocation;
import org.infinispan.hibernate.cache.v6.impl.Sync;

public class TombstoneAccessDelegate
extends org.infinispan.hibernate.cache.commons.access.TombstoneAccessDelegate {
    public TombstoneAccessDelegate(InfinispanDataRegion region) {
        super(region);
    }

    protected void write(Object session, Object key, Object value) {
        Sync sync = (Sync)((SharedSessionContractImplementor)session).getCacheTransactionSynchronization();
        FutureUpdateInvocation invocation = new FutureUpdateInvocation((FunctionalMap.ReadWriteMap<Object, Object>)this.asyncWriteMap, key, value, this.region, sync.getCachingTimestamp());
        sync.registerAfterCommit(invocation);
        Tombstone tombstone = new Tombstone(invocation.getUuid(), this.region.nextTimestamp() + this.region.getTombstoneExpiration());
        CompletableFuture future = this.writeMap.eval(key, (Function)tombstone);
        if (tombstone.isComplete()) {
            sync.registerBeforeCommit(future);
        } else {
            log.trace((Object)"Tombstone was not applied immediately, waiting.");
            future.join();
        }
    }
}

