/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v6.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.v6.impl.AbstractAccess;
import org.infinispan.hibernate.cache.v6.impl.DomainDataRegionImpl;

class ReadOnlyNaturalDataAccess
extends AbstractAccess
implements NaturalIdDataAccess {
    ReadOnlyNaturalDataAccess(AccessType accessType, AccessDelegate delegate, DomainDataRegionImpl region) {
        super(accessType, delegate, region);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.insert((Object)session, key, value, null);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.afterInsert((Object)session, key, value, null);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        return this.delegate.afterUpdate((Object)session, key, value, null, null, lock);
    }

    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        return this.delegate.get((Object)session, key, session.getCacheTransactionSynchronization().getCachingTimestamp());
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, session.getCacheTransactionSynchronization().getCachingTimestamp(), version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad((Object)session, key, value, session.getCacheTransactionSynchronization().getCachingTimestamp(), version, minimalPutOverride);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem((Object)session, key);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove((Object)session, key);
    }

    public Object generateCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.region.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object getNaturalIdValues(Object cacheKey) {
        return this.region.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

