/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v62.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.v62.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v62.impl.TimestampsRegionImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class ClusteredTimestampsRegionImpl
extends TimestampsRegionImpl {
    private final Map localCache = new ConcurrentHashMap();

    public ClusteredTimestampsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        cache.addListener((Object)this);
        this.populateLocalCache();
    }

    @Override
    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.asyncWriteCache((AdvancedCache)cache, (Flag)Flag.SKIP_LOCKING);
    }

    @Override
    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        Object value = this.localCache.get(key);
        if (value == null && this.checkValid() && (value = this.cache.get(key)) != null) {
            this.localCache.put(key, value);
        }
        return value;
    }

    @Override
    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        this.updateLocalCache(key, value);
        super.putIntoCache(key, value, session);
    }

    public void invalidateRegion() {
        super.invalidateRegion();
        this.localCache.clear();
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.cache.removeListener((Object)this);
        super.destroy();
    }

    private void populateLocalCache() {
        try (CloseableIterator iterator = this.cache.keySet().iterator();){
            while (iterator.hasNext()) {
                this.getFromCache(iterator.next(), null);
            }
        }
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (!event.isPre()) {
            this.updateLocalCache(event.getKey(), event.getValue());
        }
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.remove(event.getKey());
    }

    private void updateLocalCache(Object key, Object value) {
        this.localCache.compute(key, (k, v) -> {
            if (v instanceof Number && value instanceof Number) {
                return Math.max(((Number)v).longValue(), ((Number)value).longValue());
            }
            return value;
        });
    }
}

