/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.xsite.XSiteBackup;

public class XSiteResponseImpl<O>
extends CompletableFuture<O>
implements XSiteResponse<O>,
BiConsumer<ValidResponse<?>, Throwable> {
    private final long sendTimeNanos;
    private final TimeService timeService;
    private final XSiteBackup xSiteBackup;
    private volatile long durationNanos;

    public XSiteResponseImpl(TimeService timeService, XSiteBackup xSiteBackup) {
        this.sendTimeNanos = timeService.time();
        this.timeService = timeService;
        this.xSiteBackup = xSiteBackup;
    }

    @Override
    public void whenCompleted(XSiteResponse.XSiteResponseCompleted xSiteResponseCompleted) {
        this.whenComplete((T aVoid, U throwable) -> xSiteResponseCompleted.onCompleted(this.xSiteBackup, this.sendTimeNanos, this.durationNanos, (Throwable)throwable));
    }

    @Override
    public void accept(ValidResponse response, Throwable throwable) {
        this.durationNanos = this.timeService.timeDuration(this.sendTimeNanos, TimeUnit.NANOSECONDS);
        if (throwable != null) {
            this.completeExceptionally(throwable);
        } else {
            this.complete(response.getResponseValue());
        }
    }
}

