/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.keymappers;

import java.util.Base64;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;

public class WrappedByteArrayOrPrimitiveMapper
extends DefaultTwoWayKey2StringMapper
implements MarshallingTwoWayKey2StringMapper {
    @Override
    public String getStringMapping(Object key) {
        if (super.isSupportedType(key.getClass())) {
            return super.getStringMapping(key);
        }
        try {
            WrappedByteArray mv = (WrappedByteArray)key;
            String serializedObj = this.serializeObj(mv);
            return serializedObj;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception occurred serializing key.", ex);
        }
    }

    @Override
    public Object getKeyMapping(String key) {
        if (super.isSupportedType(key.getClass())) {
            return super.getKeyMapping(key);
        }
        try {
            WrappedByteArray obj;
            WrappedByteArray mv = obj = this.deserializeObj(key);
            return mv;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception occurred deserializing key.", ex);
        }
    }

    private String serializeObj(WrappedByteArray mv) {
        return Base64.getEncoder().encodeToString(mv.getBytes());
    }

    private WrappedByteArray deserializeObj(String key) {
        byte[] data = Base64.getDecoder().decode(key);
        return new WrappedByteArray(data);
    }

    @Override
    public boolean isSupportedType(Class<?> keyType) {
        return keyType == WrappedByteArray.class || super.isSupportedType(keyType);
    }
}

