/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.stat.CounterMetricInfo;
import org.infinispan.commons.stat.CounterTracker;
import org.infinispan.commons.stat.DistributionSummaryMetricInfo;
import org.infinispan.commons.stat.DistributionSummaryTracker;
import org.infinispan.commons.stat.FunctionTimerMetricInfo;
import org.infinispan.commons.stat.GaugeMetricInfo;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.SimpleTimerTracker;
import org.infinispan.commons.stat.TimeGaugeMetricInfo;
import org.infinispan.commons.stat.TimerMetricInfo;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.commons.stat.micrometer.MicrometerCounterTracker;
import org.infinispan.commons.stat.micrometer.MicrometerDistributionSummary;
import org.infinispan.commons.stat.micrometer.MicrometerTimerTracker;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.config.MicrometerMeterRegistryConfiguration;
import org.infinispan.metrics.impl.BaseAdditionalMetrics;
import org.infinispan.metrics.impl.JvmMetrics;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.metrics.impl.NameUtils;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
abstract class AbstractMetricsRegistry
implements MetricsRegistry {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    GlobalConfiguration globalConfiguration;
    private ScrapeRegistry registry;
    private final JvmMetrics jvmMetrics = new JvmMetrics();

    AbstractMetricsRegistry() {
    }

    @Start
    protected void start() {
        this.stop();
        boolean registerListeners = this.registry == null || !this.registry.externalManaged();
        MicrometerMeterRegistryConfiguration configuration = this.globalConfiguration.module(MicrometerMeterRegistryConfiguration.class);
        MeterRegistry configuredRegistry = configuration == null ? null : configuration.meterRegistry();
        this.registry = this.createScrapeRegistry(configuredRegistry);
        if (registerListeners) {
            if (this.globalConfiguration.metrics().jvm()) {
                if (this.globalConfiguration.metrics().legacy()) {
                    new BaseAdditionalMetrics().bindTo(this.registry.registry());
                } else {
                    this.jvmMetrics.bindTo(this.registry.registry());
                }
            }
            this.registry.registry().config().onMeterAdded(AbstractMetricsRegistry::onMeterAdded);
            this.registry.registry().config().onMeterRemoved(AbstractMetricsRegistry::onMeterRemoved);
            this.registry.registry().config().onMeterRegistrationFailed(AbstractMetricsRegistry::onMeterRegistrationFailed);
        }
    }

    @Stop
    protected void stop() {
        if (this.registry != null && !this.registry.externalManaged()) {
            this.registry.registry().close();
        }
        this.jvmMetrics.close();
    }

    abstract ScrapeRegistry createScrapeRegistry(MeterRegistry var1);

    @Override
    public Set<Object> registerMetrics(Object instance, Collection<MetricInfo> metricInfos, String namePrefix, Map<String, String> tags) {
        HashSet<Object> metricIds = new HashSet<Object>(metricInfos.size());
        for (MetricInfo info : metricInfos) {
            Meter.Id id;
            String name = AbstractMetricsRegistry.metricName(namePrefix, info);
            if (this.globalConfiguration.metrics().gauges()) {
                id = this.onGaugeEnabled(instance, name, info, tags);
                if (id != null) {
                    metricIds.add(id);
                    continue;
                }
            } else {
                this.onGaugeDisabled(instance, info);
            }
            if (this.globalConfiguration.metrics().histograms()) {
                id = this.onHistogramEnabled(instance, name, info, tags);
                if (id != null) {
                    metricIds.add(id);
                    continue;
                }
            } else {
                this.onHistogramDisabled(instance, info);
            }
            if (!log.isTraceEnabled()) continue;
            log.tracef("Metric %s not registered. Gauges enabled? %s, Histograms enabled? %s", info, this.globalConfiguration.metrics().gauges(), this.globalConfiguration.metrics().histograms());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Registered %d metrics. Metric registry @%x contains %d metrics.", metricIds.size(), System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
        }
        return metricIds;
    }

    @Override
    public void unregisterMetric(Object metricId) {
        if (!(metricId instanceof Meter.Id)) {
            if (log.isTraceEnabled()) {
                log.tracef("Metric %s is not a valid Meter.Id", metricId);
            }
            return;
        }
        Meter removed = this.registry.registry().remove((Meter.Id)metricId);
        if (log.isTraceEnabled()) {
            if (removed != null) {
                log.tracef("Unregistered metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
            } else {
                log.tracef("Could not remove unexisting metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.registry().getMeters().size());
            }
        }
    }

    @Override
    @Deprecated(forRemoval=true, since="16.0")
    public boolean legacy() {
        return this.globalConfiguration.metrics().legacy();
    }

    @Override
    @Deprecated(forRemoval=true, since="16.0")
    public boolean namesAsTags() {
        return this.globalConfiguration.metrics().namesAsTags();
    }

    @Override
    public boolean supportScrape() {
        return this.registry.supportsScrape();
    }

    @Override
    public String scrape(String contentType) {
        return this.registry.scrape(contentType);
    }

    protected MeterRegistry registry() {
        return this.registry.registry();
    }

    private static void onMeterAdded(Meter meter) {
        if (log.isDebugEnabled()) {
            log.debugf("Registered metric %s", meter.getId());
        }
    }

    private static void onMeterRemoved(Meter meter) {
        if (log.isDebugEnabled()) {
            log.debugf("Unregistered metric %s", meter.getId());
        }
    }

    private static void onMeterRegistrationFailed(Meter.Id id, String reason) {
        log.metricRegistrationFailed(String.valueOf(id), reason);
    }

    private Meter.Id onGaugeEnabled(Object targetInstance, String name, MetricInfo metricInfo, Map<String, String> commonTags) {
        if (metricInfo instanceof GaugeMetricInfo) {
            return this.createGauge(targetInstance, name, (GaugeMetricInfo<Object>)((GaugeMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof CounterMetricInfo) {
            return this.createCounter(targetInstance, name, (CounterMetricInfo<Object>)((CounterMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof FunctionTimerMetricInfo) {
            return this.createFunctionTimer(targetInstance, name, (FunctionTimerMetricInfo<Object>)((FunctionTimerMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof TimeGaugeMetricInfo) {
            return this.createTimeGauge(targetInstance, name, (TimeGaugeMetricInfo<Object>)((TimeGaugeMetricInfo)metricInfo), commonTags);
        }
        return null;
    }

    private void onGaugeDisabled(Object targetInstance, MetricInfo metricInfo) {
        if (metricInfo instanceof CounterMetricInfo) {
            ((CounterMetricInfo)metricInfo).accept(targetInstance, (Object)CounterTracker.NO_OP);
        } else if (metricInfo instanceof FunctionTimerMetricInfo) {
            ((FunctionTimerMetricInfo)metricInfo).accept(targetInstance, (Object)TimerTracker.NO_OP);
        }
    }

    private Meter.Id onHistogramEnabled(Object targetInstance, String name, MetricInfo metricInfo, Map<String, String> commonTags) {
        if (metricInfo instanceof TimerMetricInfo) {
            return this.createTimer(targetInstance, name, (TimerMetricInfo<Object>)((TimerMetricInfo)metricInfo), commonTags);
        }
        if (metricInfo instanceof DistributionSummaryMetricInfo) {
            return this.createSummary(targetInstance, name, (DistributionSummaryMetricInfo<Object>)((DistributionSummaryMetricInfo)metricInfo), commonTags);
        }
        return null;
    }

    private void onHistogramDisabled(Object targetInstance, MetricInfo metricInfo) {
        if (metricInfo instanceof TimerMetricInfo) {
            ((TimerMetricInfo)metricInfo).accept(targetInstance, (Object)TimerTracker.NO_OP);
        } else if (metricInfo instanceof DistributionSummaryMetricInfo) {
            ((DistributionSummaryMetricInfo)metricInfo).accept(targetInstance, (Object)DistributionSummaryTracker.NO_OP);
        }
    }

    private Collection<Tag> createTags(Map<String, String> attrTags, Map<String, String> tags) {
        TreeMap<String, String> allTags = new TreeMap<String, String>();
        allTags.put("cache_manager", this.globalConfiguration.cacheManagerName());
        if (tags != null) {
            allTags.putAll(tags);
        }
        if (attrTags != null) {
            allTags.putAll(attrTags);
        }
        return allTags.entrySet().stream().map(AbstractMetricsRegistry::tagFromMapEntry).collect(Collectors.toList());
    }

    private static Tag tagFromMapEntry(Map.Entry<String, String> entry) {
        return Tag.of((String)entry.getKey(), (String)entry.getValue());
    }

    private static String metricName(String prefix, MetricInfo info) {
        return prefix + NameUtils.decamelize(info.getName());
    }

    private Meter.Id createTimeGauge(Object instance, String name, TimeGaugeMetricInfo<Object> info, Map<String, String> tags) {
        return TimeGauge.builder((String)name, (Supplier)info.getGauge(instance), (TimeUnit)info.getTimeUnit()).strongReference(true).tags(this.createTags(info.getTags(), tags)).description(info.getDescription()).register(this.registry.registry()).getId();
    }

    private Meter.Id createGauge(Object instance, String name, GaugeMetricInfo<Object> info, Map<String, String> tags) {
        return Gauge.builder((String)name, (Supplier)info.getGauge(instance)).strongReference(true).tags(this.createTags(info.getTags(), tags)).description(info.getDescription()).register(this.registry.registry()).getId();
    }

    private Meter.Id createCounter(Object instance, String name, CounterMetricInfo<Object> info, Map<String, String> tags) {
        Counter counter = Counter.builder((String)name).description(info.getDescription()).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new MicrometerCounterTracker(counter));
        return counter.getId();
    }

    private Meter.Id createFunctionTimer(Object instance, String name, FunctionTimerMetricInfo<Object> info, Map<String, String> tags) {
        SimpleTimerTracker timerTracker = new SimpleTimerTracker();
        info.accept(instance, (Object)timerTracker);
        return FunctionTimer.builder((String)name, (Object)timerTracker, SimpleTimerTracker::count, SimpleTimerTracker::totalTime, (TimeUnit)TimeUnit.NANOSECONDS).description(info.getDescription()).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry()).getId();
    }

    private Meter.Id createTimer(Object instance, String name, TimerMetricInfo<Object> info, Map<String, String> tags) {
        Timer timer = Timer.builder((String)name).description(info.getDescription()).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new MicrometerTimerTracker(timer));
        return timer.getId();
    }

    private Meter.Id createSummary(Object instance, String name, DistributionSummaryMetricInfo<Object> info, Map<String, String> tags) {
        DistributionSummary summary = DistributionSummary.builder((String)name).description(info.getDescription()).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(info.getTags(), tags)).register(this.registry.registry());
        info.accept(instance, (Object)new MicrometerDistributionSummary(summary));
        return summary.getId();
    }

    protected static interface ScrapeRegistry {
        public boolean supportsScrape();

        public String scrape(String var1);

        public MeterRegistry registry();

        public boolean externalManaged();
    }

    protected record NoScrapeRegistry(MeterRegistry registry, boolean externalManaged) implements ScrapeRegistry
    {
        @Override
        public boolean supportsScrape() {
            return false;
        }

        @Override
        public String scrape(String contentType) {
            return null;
        }
    }
}

